/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=Deserializer.class)
public final class CreateContactRequest {
    private final Object value;
    private final int type;

    private CreateContactRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((WithEmail)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((WithExternalId)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((WithRole)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateContactRequest && this.equalTo((CreateContactRequest)other);
    }

    private boolean equalTo(CreateContactRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static CreateContactRequest of(WithEmail value) {
        return new CreateContactRequest(value, 0);
    }

    public static CreateContactRequest of(WithExternalId value) {
        return new CreateContactRequest(value, 1);
    }

    public static CreateContactRequest of(WithRole value) {
        return new CreateContactRequest(value, 2);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithExternalId {
        private final String externalId;
        private final Optional<String> phone;
        private final Optional<String> name;
        private final Optional<String> avatar;
        private final Optional<Integer> signedUpAt;
        private final Optional<Integer> lastSeenAt;
        private final Optional<Integer> ownerId;
        private final Optional<Boolean> unsubscribedFromEmails;
        private final Optional<Map<String, Object>> customAttributes;
        private final Map<String, Object> additionalProperties;

        private WithExternalId(String externalId, Optional<String> phone, Optional<String> name, Optional<String> avatar, Optional<Integer> signedUpAt, Optional<Integer> lastSeenAt, Optional<Integer> ownerId, Optional<Boolean> unsubscribedFromEmails, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
            this.externalId = externalId;
            this.phone = phone;
            this.name = name;
            this.avatar = avatar;
            this.signedUpAt = signedUpAt;
            this.lastSeenAt = lastSeenAt;
            this.ownerId = ownerId;
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="external_id")
        public String getExternalId() {
            return this.externalId;
        }

        @JsonProperty(value="phone")
        public Optional<String> getPhone() {
            return this.phone;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty(value="avatar")
        public Optional<String> getAvatar() {
            return this.avatar;
        }

        @JsonProperty(value="signed_up_at")
        public Optional<Integer> getSignedUpAt() {
            return this.signedUpAt;
        }

        @JsonProperty(value="last_seen_at")
        public Optional<Integer> getLastSeenAt() {
            return this.lastSeenAt;
        }

        @JsonProperty(value="owner_id")
        public Optional<Integer> getOwnerId() {
            return this.ownerId;
        }

        @JsonProperty(value="unsubscribed_from_emails")
        public Optional<Boolean> getUnsubscribedFromEmails() {
            return this.unsubscribedFromEmails;
        }

        @JsonProperty(value="custom_attributes")
        public Optional<Map<String, Object>> getCustomAttributes() {
            return this.customAttributes;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithExternalId && this.equalTo((WithExternalId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithExternalId other) {
            return this.externalId.equals(other.externalId) && this.phone.equals(other.phone) && this.name.equals(other.name) && this.avatar.equals(other.avatar) && this.signedUpAt.equals(other.signedUpAt) && this.lastSeenAt.equals(other.lastSeenAt) && this.ownerId.equals(other.ownerId) && this.unsubscribedFromEmails.equals(other.unsubscribedFromEmails) && this.customAttributes.equals(other.customAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.externalId, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ExternalIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements ExternalIdStage,
        _FinalStage {
            private String externalId;
            private Optional<Map<String, Object>> customAttributes = Optional.empty();
            private Optional<Boolean> unsubscribedFromEmails = Optional.empty();
            private Optional<Integer> ownerId = Optional.empty();
            private Optional<Integer> lastSeenAt = Optional.empty();
            private Optional<Integer> signedUpAt = Optional.empty();
            private Optional<String> avatar = Optional.empty();
            private Optional<String> name = Optional.empty();
            private Optional<String> phone = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithExternalId other) {
                this.externalId(other.getExternalId());
                this.phone(other.getPhone());
                this.name(other.getName());
                this.avatar(other.getAvatar());
                this.signedUpAt(other.getSignedUpAt());
                this.lastSeenAt(other.getLastSeenAt());
                this.ownerId(other.getOwnerId());
                this.unsubscribedFromEmails(other.getUnsubscribedFromEmails());
                this.customAttributes(other.getCustomAttributes());
                return this;
            }

            @Override
            @JsonSetter(value="external_id")
            public _FinalStage externalId(@NotNull String externalId) {
                this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
                return this;
            }

            @Override
            public _FinalStage customAttributes(Map<String, Object> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            @Override
            @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            @Override
            public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
                this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
                return this;
            }

            @Override
            @JsonSetter(value="unsubscribed_from_emails", nulls=Nulls.SKIP)
            public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
                this.unsubscribedFromEmails = unsubscribedFromEmails;
                return this;
            }

            @Override
            public _FinalStage ownerId(Integer ownerId) {
                this.ownerId = Optional.ofNullable(ownerId);
                return this;
            }

            @Override
            @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
            public _FinalStage ownerId(Optional<Integer> ownerId) {
                this.ownerId = ownerId;
                return this;
            }

            @Override
            public _FinalStage lastSeenAt(Integer lastSeenAt) {
                this.lastSeenAt = Optional.ofNullable(lastSeenAt);
                return this;
            }

            @Override
            @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
            public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
                this.lastSeenAt = lastSeenAt;
                return this;
            }

            @Override
            public _FinalStage signedUpAt(Integer signedUpAt) {
                this.signedUpAt = Optional.ofNullable(signedUpAt);
                return this;
            }

            @Override
            @JsonSetter(value="signed_up_at", nulls=Nulls.SKIP)
            public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
                this.signedUpAt = signedUpAt;
                return this;
            }

            @Override
            public _FinalStage avatar(String avatar) {
                this.avatar = Optional.ofNullable(avatar);
                return this;
            }

            @Override
            @JsonSetter(value="avatar", nulls=Nulls.SKIP)
            public _FinalStage avatar(Optional<String> avatar) {
                this.avatar = avatar;
                return this;
            }

            @Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            @Override
            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @Override
            public _FinalStage phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            @Override
            @JsonSetter(value="phone", nulls=Nulls.SKIP)
            public _FinalStage phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            @Override
            public WithExternalId build() {
                return new WithExternalId(this.externalId, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithExternalId build();

            public _FinalStage phone(Optional<String> var1);

            public _FinalStage phone(String var1);

            public _FinalStage name(Optional<String> var1);

            public _FinalStage name(String var1);

            public _FinalStage avatar(Optional<String> var1);

            public _FinalStage avatar(String var1);

            public _FinalStage signedUpAt(Optional<Integer> var1);

            public _FinalStage signedUpAt(Integer var1);

            public _FinalStage lastSeenAt(Optional<Integer> var1);

            public _FinalStage lastSeenAt(Integer var1);

            public _FinalStage ownerId(Optional<Integer> var1);

            public _FinalStage ownerId(Integer var1);

            public _FinalStage unsubscribedFromEmails(Optional<Boolean> var1);

            public _FinalStage unsubscribedFromEmails(Boolean var1);

            public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

            public _FinalStage customAttributes(Map<String, Object> var1);
        }

        public static interface ExternalIdStage {
            public _FinalStage externalId(@NotNull String var1);

            public Builder from(WithExternalId var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithRole {
        private final String role;
        private final Optional<String> phone;
        private final Optional<String> name;
        private final Optional<String> avatar;
        private final Optional<Integer> signedUpAt;
        private final Optional<Integer> lastSeenAt;
        private final Optional<Integer> ownerId;
        private final Optional<Boolean> unsubscribedFromEmails;
        private final Optional<Map<String, Object>> customAttributes;
        private final Map<String, Object> additionalProperties;

        private WithRole(String role, Optional<String> phone, Optional<String> name, Optional<String> avatar, Optional<Integer> signedUpAt, Optional<Integer> lastSeenAt, Optional<Integer> ownerId, Optional<Boolean> unsubscribedFromEmails, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
            this.role = role;
            this.phone = phone;
            this.name = name;
            this.avatar = avatar;
            this.signedUpAt = signedUpAt;
            this.lastSeenAt = lastSeenAt;
            this.ownerId = ownerId;
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="role")
        public String getRole() {
            return this.role;
        }

        @JsonProperty(value="phone")
        public Optional<String> getPhone() {
            return this.phone;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty(value="avatar")
        public Optional<String> getAvatar() {
            return this.avatar;
        }

        @JsonProperty(value="signed_up_at")
        public Optional<Integer> getSignedUpAt() {
            return this.signedUpAt;
        }

        @JsonProperty(value="last_seen_at")
        public Optional<Integer> getLastSeenAt() {
            return this.lastSeenAt;
        }

        @JsonProperty(value="owner_id")
        public Optional<Integer> getOwnerId() {
            return this.ownerId;
        }

        @JsonProperty(value="unsubscribed_from_emails")
        public Optional<Boolean> getUnsubscribedFromEmails() {
            return this.unsubscribedFromEmails;
        }

        @JsonProperty(value="custom_attributes")
        public Optional<Map<String, Object>> getCustomAttributes() {
            return this.customAttributes;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithRole && this.equalTo((WithRole)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithRole other) {
            return this.role.equals(other.role) && this.phone.equals(other.phone) && this.name.equals(other.name) && this.avatar.equals(other.avatar) && this.signedUpAt.equals(other.signedUpAt) && this.lastSeenAt.equals(other.lastSeenAt) && this.ownerId.equals(other.ownerId) && this.unsubscribedFromEmails.equals(other.unsubscribedFromEmails) && this.customAttributes.equals(other.customAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.role, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static RoleStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements RoleStage,
        _FinalStage {
            private String role;
            private Optional<Map<String, Object>> customAttributes = Optional.empty();
            private Optional<Boolean> unsubscribedFromEmails = Optional.empty();
            private Optional<Integer> ownerId = Optional.empty();
            private Optional<Integer> lastSeenAt = Optional.empty();
            private Optional<Integer> signedUpAt = Optional.empty();
            private Optional<String> avatar = Optional.empty();
            private Optional<String> name = Optional.empty();
            private Optional<String> phone = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithRole other) {
                this.role(other.getRole());
                this.phone(other.getPhone());
                this.name(other.getName());
                this.avatar(other.getAvatar());
                this.signedUpAt(other.getSignedUpAt());
                this.lastSeenAt(other.getLastSeenAt());
                this.ownerId(other.getOwnerId());
                this.unsubscribedFromEmails(other.getUnsubscribedFromEmails());
                this.customAttributes(other.getCustomAttributes());
                return this;
            }

            @Override
            @JsonSetter(value="role")
            public _FinalStage role(@NotNull String role) {
                this.role = Objects.requireNonNull(role, "role must not be null");
                return this;
            }

            @Override
            public _FinalStage customAttributes(Map<String, Object> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            @Override
            @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            @Override
            public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
                this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
                return this;
            }

            @Override
            @JsonSetter(value="unsubscribed_from_emails", nulls=Nulls.SKIP)
            public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
                this.unsubscribedFromEmails = unsubscribedFromEmails;
                return this;
            }

            @Override
            public _FinalStage ownerId(Integer ownerId) {
                this.ownerId = Optional.ofNullable(ownerId);
                return this;
            }

            @Override
            @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
            public _FinalStage ownerId(Optional<Integer> ownerId) {
                this.ownerId = ownerId;
                return this;
            }

            @Override
            public _FinalStage lastSeenAt(Integer lastSeenAt) {
                this.lastSeenAt = Optional.ofNullable(lastSeenAt);
                return this;
            }

            @Override
            @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
            public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
                this.lastSeenAt = lastSeenAt;
                return this;
            }

            @Override
            public _FinalStage signedUpAt(Integer signedUpAt) {
                this.signedUpAt = Optional.ofNullable(signedUpAt);
                return this;
            }

            @Override
            @JsonSetter(value="signed_up_at", nulls=Nulls.SKIP)
            public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
                this.signedUpAt = signedUpAt;
                return this;
            }

            @Override
            public _FinalStage avatar(String avatar) {
                this.avatar = Optional.ofNullable(avatar);
                return this;
            }

            @Override
            @JsonSetter(value="avatar", nulls=Nulls.SKIP)
            public _FinalStage avatar(Optional<String> avatar) {
                this.avatar = avatar;
                return this;
            }

            @Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            @Override
            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @Override
            public _FinalStage phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            @Override
            @JsonSetter(value="phone", nulls=Nulls.SKIP)
            public _FinalStage phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            @Override
            public WithRole build() {
                return new WithRole(this.role, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithRole build();

            public _FinalStage phone(Optional<String> var1);

            public _FinalStage phone(String var1);

            public _FinalStage name(Optional<String> var1);

            public _FinalStage name(String var1);

            public _FinalStage avatar(Optional<String> var1);

            public _FinalStage avatar(String var1);

            public _FinalStage signedUpAt(Optional<Integer> var1);

            public _FinalStage signedUpAt(Integer var1);

            public _FinalStage lastSeenAt(Optional<Integer> var1);

            public _FinalStage lastSeenAt(Integer var1);

            public _FinalStage ownerId(Optional<Integer> var1);

            public _FinalStage ownerId(Integer var1);

            public _FinalStage unsubscribedFromEmails(Optional<Boolean> var1);

            public _FinalStage unsubscribedFromEmails(Boolean var1);

            public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

            public _FinalStage customAttributes(Map<String, Object> var1);
        }

        public static interface RoleStage {
            public _FinalStage role(@NotNull String var1);

            public Builder from(WithRole var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithEmail {
        private final String email;
        private final Optional<String> phone;
        private final Optional<String> name;
        private final Optional<String> avatar;
        private final Optional<Integer> signedUpAt;
        private final Optional<Integer> lastSeenAt;
        private final Optional<Integer> ownerId;
        private final Optional<Boolean> unsubscribedFromEmails;
        private final Optional<Map<String, Object>> customAttributes;
        private final Map<String, Object> additionalProperties;

        private WithEmail(String email, Optional<String> phone, Optional<String> name, Optional<String> avatar, Optional<Integer> signedUpAt, Optional<Integer> lastSeenAt, Optional<Integer> ownerId, Optional<Boolean> unsubscribedFromEmails, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
            this.email = email;
            this.phone = phone;
            this.name = name;
            this.avatar = avatar;
            this.signedUpAt = signedUpAt;
            this.lastSeenAt = lastSeenAt;
            this.ownerId = ownerId;
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="email")
        public String getEmail() {
            return this.email;
        }

        @JsonProperty(value="phone")
        public Optional<String> getPhone() {
            return this.phone;
        }

        @JsonProperty(value="name")
        public Optional<String> getName() {
            return this.name;
        }

        @JsonProperty(value="avatar")
        public Optional<String> getAvatar() {
            return this.avatar;
        }

        @JsonProperty(value="signed_up_at")
        public Optional<Integer> getSignedUpAt() {
            return this.signedUpAt;
        }

        @JsonProperty(value="last_seen_at")
        public Optional<Integer> getLastSeenAt() {
            return this.lastSeenAt;
        }

        @JsonProperty(value="owner_id")
        public Optional<Integer> getOwnerId() {
            return this.ownerId;
        }

        @JsonProperty(value="unsubscribed_from_emails")
        public Optional<Boolean> getUnsubscribedFromEmails() {
            return this.unsubscribedFromEmails;
        }

        @JsonProperty(value="custom_attributes")
        public Optional<Map<String, Object>> getCustomAttributes() {
            return this.customAttributes;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithEmail && this.equalTo((WithEmail)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithEmail other) {
            return this.email.equals(other.email) && this.phone.equals(other.phone) && this.name.equals(other.name) && this.avatar.equals(other.avatar) && this.signedUpAt.equals(other.signedUpAt) && this.lastSeenAt.equals(other.lastSeenAt) && this.ownerId.equals(other.ownerId) && this.unsubscribedFromEmails.equals(other.unsubscribedFromEmails) && this.customAttributes.equals(other.customAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.email, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static EmailStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements EmailStage,
        _FinalStage {
            private String email;
            private Optional<Map<String, Object>> customAttributes = Optional.empty();
            private Optional<Boolean> unsubscribedFromEmails = Optional.empty();
            private Optional<Integer> ownerId = Optional.empty();
            private Optional<Integer> lastSeenAt = Optional.empty();
            private Optional<Integer> signedUpAt = Optional.empty();
            private Optional<String> avatar = Optional.empty();
            private Optional<String> name = Optional.empty();
            private Optional<String> phone = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithEmail other) {
                this.email(other.getEmail());
                this.phone(other.getPhone());
                this.name(other.getName());
                this.avatar(other.getAvatar());
                this.signedUpAt(other.getSignedUpAt());
                this.lastSeenAt(other.getLastSeenAt());
                this.ownerId(other.getOwnerId());
                this.unsubscribedFromEmails(other.getUnsubscribedFromEmails());
                this.customAttributes(other.getCustomAttributes());
                return this;
            }

            @Override
            @JsonSetter(value="email")
            public _FinalStage email(@NotNull String email) {
                this.email = Objects.requireNonNull(email, "email must not be null");
                return this;
            }

            @Override
            public _FinalStage customAttributes(Map<String, Object> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            @Override
            @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            @Override
            public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
                this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
                return this;
            }

            @Override
            @JsonSetter(value="unsubscribed_from_emails", nulls=Nulls.SKIP)
            public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
                this.unsubscribedFromEmails = unsubscribedFromEmails;
                return this;
            }

            @Override
            public _FinalStage ownerId(Integer ownerId) {
                this.ownerId = Optional.ofNullable(ownerId);
                return this;
            }

            @Override
            @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
            public _FinalStage ownerId(Optional<Integer> ownerId) {
                this.ownerId = ownerId;
                return this;
            }

            @Override
            public _FinalStage lastSeenAt(Integer lastSeenAt) {
                this.lastSeenAt = Optional.ofNullable(lastSeenAt);
                return this;
            }

            @Override
            @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
            public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
                this.lastSeenAt = lastSeenAt;
                return this;
            }

            @Override
            public _FinalStage signedUpAt(Integer signedUpAt) {
                this.signedUpAt = Optional.ofNullable(signedUpAt);
                return this;
            }

            @Override
            @JsonSetter(value="signed_up_at", nulls=Nulls.SKIP)
            public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
                this.signedUpAt = signedUpAt;
                return this;
            }

            @Override
            public _FinalStage avatar(String avatar) {
                this.avatar = Optional.ofNullable(avatar);
                return this;
            }

            @Override
            @JsonSetter(value="avatar", nulls=Nulls.SKIP)
            public _FinalStage avatar(Optional<String> avatar) {
                this.avatar = avatar;
                return this;
            }

            @Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            @Override
            @JsonSetter(value="name", nulls=Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            @Override
            public _FinalStage phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            @Override
            @JsonSetter(value="phone", nulls=Nulls.SKIP)
            public _FinalStage phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            @Override
            public WithEmail build() {
                return new WithEmail(this.email, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithEmail build();

            public _FinalStage phone(Optional<String> var1);

            public _FinalStage phone(String var1);

            public _FinalStage name(Optional<String> var1);

            public _FinalStage name(String var1);

            public _FinalStage avatar(Optional<String> var1);

            public _FinalStage avatar(String var1);

            public _FinalStage signedUpAt(Optional<Integer> var1);

            public _FinalStage signedUpAt(Integer var1);

            public _FinalStage lastSeenAt(Optional<Integer> var1);

            public _FinalStage lastSeenAt(Integer var1);

            public _FinalStage ownerId(Optional<Integer> var1);

            public _FinalStage ownerId(Integer var1);

            public _FinalStage unsubscribedFromEmails(Optional<Boolean> var1);

            public _FinalStage unsubscribedFromEmails(Boolean var1);

            public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

            public _FinalStage customAttributes(Map<String, Object> var1);
        }

        public static interface EmailStage {
            public _FinalStage email(@NotNull String var1);

            public Builder from(WithEmail var1);
        }
    }

    static final class Deserializer
    extends StdDeserializer<CreateContactRequest> {
        Deserializer() {
            super(CreateContactRequest.class);
        }

        public CreateContactRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return CreateContactRequest.of((WithEmail)ObjectMappers.JSON_MAPPER.convertValue(value, WithEmail.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return CreateContactRequest.of((WithExternalId)ObjectMappers.JSON_MAPPER.convertValue(value, WithExternalId.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return CreateContactRequest.of((WithRole)ObjectMappers.JSON_MAPPER.convertValue(value, WithRole.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(WithEmail var1);

        public T visit(WithExternalId var1);

        public T visit(WithRole var1);
    }
}

