/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.dataevents.types.DataEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataEventList {
    private final List<DataEvent> events;
    private final Optional<Pages> pages;
    private final Map<String, Object> additionalProperties;

    private DataEventList(List<DataEvent> events, Optional<Pages> pages, Map<String, Object> additionalProperties) {
        this.events = events;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "event.list";
    }

    @JsonProperty(value="events")
    public List<DataEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="pages")
    public Optional<Pages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataEventList && this.equalTo((DataEventList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventList other) {
        return this.events.equals(other.events) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Pages {
        private final Optional<String> next;
        private final Optional<String> since;
        private final Map<String, Object> additionalProperties;

        private Pages(Optional<String> next, Optional<String> since, Map<String, Object> additionalProperties) {
            this.next = next;
            this.since = since;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="next")
        public Optional<String> getNext() {
            return this.next;
        }

        @JsonProperty(value="since")
        public Optional<String> getSince() {
            return this.since;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Pages && this.equalTo((Pages)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Pages other) {
            return this.next.equals(other.next) && this.since.equals(other.since);
        }

        public int hashCode() {
            return Objects.hash(this.next, this.since);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> next = Optional.empty();
            private Optional<String> since = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Pages other) {
                this.next(other.getNext());
                this.since(other.getSince());
                return this;
            }

            @JsonSetter(value="next", nulls=Nulls.SKIP)
            public Builder next(Optional<String> next) {
                this.next = next;
                return this;
            }

            public Builder next(String next) {
                this.next = Optional.ofNullable(next);
                return this;
            }

            @JsonSetter(value="since", nulls=Nulls.SKIP)
            public Builder since(Optional<String> since) {
                this.since = since;
                return this;
            }

            public Builder since(String since) {
                this.since = Optional.ofNullable(since);
                return this;
            }

            public Pages build() {
                return new Pages(this.next, this.since, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<DataEvent> events = new ArrayList<DataEvent>();
        private Optional<Pages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DataEventList other) {
            this.events(other.getEvents());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public Builder events(List<DataEvent> events) {
            this.events.clear();
            this.events.addAll(events);
            return this;
        }

        public Builder addEvents(DataEvent events) {
            this.events.add(events);
            return this;
        }

        public Builder addAllEvents(List<DataEvent> events) {
            this.events.addAll(events);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<Pages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Pages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public DataEventList build() {
            return new DataEventList(this.events, this.pages, this.additionalProperties);
        }
    }
}

