/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataExportCsv {
    private final String userId;
    private final Optional<String> userExternalId;
    private final String companyId;
    private final String email;
    private final String name;
    private final String rulesetId;
    private final String contentId;
    private final String contentType;
    private final String contentTitle;
    private final Optional<String> rulesetVersionId;
    private final Optional<String> receiptId;
    private final Optional<Integer> receivedAt;
    private final Optional<String> seriesId;
    private final Optional<String> seriesTitle;
    private final Optional<String> nodeId;
    private final Optional<Integer> firstReply;
    private final Optional<Integer> firstCompletion;
    private final Optional<Integer> firstSeriesCompletion;
    private final Optional<Integer> firstSeriesDisengagement;
    private final Optional<Integer> firstSeriesExit;
    private final Optional<Integer> firstGoalSuccess;
    private final Optional<Integer> firstOpen;
    private final Optional<Integer> firstClick;
    private final Optional<Integer> firstDismisall;
    private final Optional<Integer> firstUnsubscribe;
    private final Optional<Integer> firstHardBounce;
    private final Map<String, Object> additionalProperties;

    private DataExportCsv(String userId, Optional<String> userExternalId, String companyId, String email, String name, String rulesetId, String contentId, String contentType, String contentTitle, Optional<String> rulesetVersionId, Optional<String> receiptId, Optional<Integer> receivedAt, Optional<String> seriesId, Optional<String> seriesTitle, Optional<String> nodeId, Optional<Integer> firstReply, Optional<Integer> firstCompletion, Optional<Integer> firstSeriesCompletion, Optional<Integer> firstSeriesDisengagement, Optional<Integer> firstSeriesExit, Optional<Integer> firstGoalSuccess, Optional<Integer> firstOpen, Optional<Integer> firstClick, Optional<Integer> firstDismisall, Optional<Integer> firstUnsubscribe, Optional<Integer> firstHardBounce, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.userExternalId = userExternalId;
        this.companyId = companyId;
        this.email = email;
        this.name = name;
        this.rulesetId = rulesetId;
        this.contentId = contentId;
        this.contentType = contentType;
        this.contentTitle = contentTitle;
        this.rulesetVersionId = rulesetVersionId;
        this.receiptId = receiptId;
        this.receivedAt = receivedAt;
        this.seriesId = seriesId;
        this.seriesTitle = seriesTitle;
        this.nodeId = nodeId;
        this.firstReply = firstReply;
        this.firstCompletion = firstCompletion;
        this.firstSeriesCompletion = firstSeriesCompletion;
        this.firstSeriesDisengagement = firstSeriesDisengagement;
        this.firstSeriesExit = firstSeriesExit;
        this.firstGoalSuccess = firstGoalSuccess;
        this.firstOpen = firstOpen;
        this.firstClick = firstClick;
        this.firstDismisall = firstDismisall;
        this.firstUnsubscribe = firstUnsubscribe;
        this.firstHardBounce = firstHardBounce;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_external_id")
    public Optional<String> getUserExternalId() {
        return this.userExternalId;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="ruleset_id")
    public String getRulesetId() {
        return this.rulesetId;
    }

    @JsonProperty(value="content_id")
    public String getContentId() {
        return this.contentId;
    }

    @JsonProperty(value="content_type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_title")
    public String getContentTitle() {
        return this.contentTitle;
    }

    @JsonProperty(value="ruleset_version_id")
    public Optional<String> getRulesetVersionId() {
        return this.rulesetVersionId;
    }

    @JsonProperty(value="receipt_id")
    public Optional<String> getReceiptId() {
        return this.receiptId;
    }

    @JsonProperty(value="received_at")
    public Optional<Integer> getReceivedAt() {
        return this.receivedAt;
    }

    @JsonProperty(value="series_id")
    public Optional<String> getSeriesId() {
        return this.seriesId;
    }

    @JsonProperty(value="series_title")
    public Optional<String> getSeriesTitle() {
        return this.seriesTitle;
    }

    @JsonProperty(value="node_id")
    public Optional<String> getNodeId() {
        return this.nodeId;
    }

    @JsonProperty(value="first_reply")
    public Optional<Integer> getFirstReply() {
        return this.firstReply;
    }

    @JsonProperty(value="first_completion")
    public Optional<Integer> getFirstCompletion() {
        return this.firstCompletion;
    }

    @JsonProperty(value="first_series_completion")
    public Optional<Integer> getFirstSeriesCompletion() {
        return this.firstSeriesCompletion;
    }

    @JsonProperty(value="first_series_disengagement")
    public Optional<Integer> getFirstSeriesDisengagement() {
        return this.firstSeriesDisengagement;
    }

    @JsonProperty(value="first_series_exit")
    public Optional<Integer> getFirstSeriesExit() {
        return this.firstSeriesExit;
    }

    @JsonProperty(value="first_goal_success")
    public Optional<Integer> getFirstGoalSuccess() {
        return this.firstGoalSuccess;
    }

    @JsonProperty(value="first_open")
    public Optional<Integer> getFirstOpen() {
        return this.firstOpen;
    }

    @JsonProperty(value="first_click")
    public Optional<Integer> getFirstClick() {
        return this.firstClick;
    }

    @JsonProperty(value="first_dismisall")
    public Optional<Integer> getFirstDismisall() {
        return this.firstDismisall;
    }

    @JsonProperty(value="first_unsubscribe")
    public Optional<Integer> getFirstUnsubscribe() {
        return this.firstUnsubscribe;
    }

    @JsonProperty(value="first_hard_bounce")
    public Optional<Integer> getFirstHardBounce() {
        return this.firstHardBounce;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataExportCsv && this.equalTo((DataExportCsv)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExportCsv other) {
        return this.userId.equals(other.userId) && this.userExternalId.equals(other.userExternalId) && this.companyId.equals(other.companyId) && this.email.equals(other.email) && this.name.equals(other.name) && this.rulesetId.equals(other.rulesetId) && this.contentId.equals(other.contentId) && this.contentType.equals(other.contentType) && this.contentTitle.equals(other.contentTitle) && this.rulesetVersionId.equals(other.rulesetVersionId) && this.receiptId.equals(other.receiptId) && this.receivedAt.equals(other.receivedAt) && this.seriesId.equals(other.seriesId) && this.seriesTitle.equals(other.seriesTitle) && this.nodeId.equals(other.nodeId) && this.firstReply.equals(other.firstReply) && this.firstCompletion.equals(other.firstCompletion) && this.firstSeriesCompletion.equals(other.firstSeriesCompletion) && this.firstSeriesDisengagement.equals(other.firstSeriesDisengagement) && this.firstSeriesExit.equals(other.firstSeriesExit) && this.firstGoalSuccess.equals(other.firstGoalSuccess) && this.firstOpen.equals(other.firstOpen) && this.firstClick.equals(other.firstClick) && this.firstDismisall.equals(other.firstDismisall) && this.firstUnsubscribe.equals(other.firstUnsubscribe) && this.firstHardBounce.equals(other.firstHardBounce);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.userExternalId, this.companyId, this.email, this.name, this.rulesetId, this.contentId, this.contentType, this.contentTitle, this.rulesetVersionId, this.receiptId, this.receivedAt, this.seriesId, this.seriesTitle, this.nodeId, this.firstReply, this.firstCompletion, this.firstSeriesCompletion, this.firstSeriesDisengagement, this.firstSeriesExit, this.firstGoalSuccess, this.firstOpen, this.firstClick, this.firstDismisall, this.firstUnsubscribe, this.firstHardBounce);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserIdStage,
    CompanyIdStage,
    EmailStage,
    NameStage,
    RulesetIdStage,
    ContentIdStage,
    ContentTypeStage,
    ContentTitleStage,
    _FinalStage {
        private String userId;
        private String companyId;
        private String email;
        private String name;
        private String rulesetId;
        private String contentId;
        private String contentType;
        private String contentTitle;
        private Optional<Integer> firstHardBounce = Optional.empty();
        private Optional<Integer> firstUnsubscribe = Optional.empty();
        private Optional<Integer> firstDismisall = Optional.empty();
        private Optional<Integer> firstClick = Optional.empty();
        private Optional<Integer> firstOpen = Optional.empty();
        private Optional<Integer> firstGoalSuccess = Optional.empty();
        private Optional<Integer> firstSeriesExit = Optional.empty();
        private Optional<Integer> firstSeriesDisengagement = Optional.empty();
        private Optional<Integer> firstSeriesCompletion = Optional.empty();
        private Optional<Integer> firstCompletion = Optional.empty();
        private Optional<Integer> firstReply = Optional.empty();
        private Optional<String> nodeId = Optional.empty();
        private Optional<String> seriesTitle = Optional.empty();
        private Optional<String> seriesId = Optional.empty();
        private Optional<Integer> receivedAt = Optional.empty();
        private Optional<String> receiptId = Optional.empty();
        private Optional<String> rulesetVersionId = Optional.empty();
        private Optional<String> userExternalId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataExportCsv other) {
            this.userId(other.getUserId());
            this.userExternalId(other.getUserExternalId());
            this.companyId(other.getCompanyId());
            this.email(other.getEmail());
            this.name(other.getName());
            this.rulesetId(other.getRulesetId());
            this.contentId(other.getContentId());
            this.contentType(other.getContentType());
            this.contentTitle(other.getContentTitle());
            this.rulesetVersionId(other.getRulesetVersionId());
            this.receiptId(other.getReceiptId());
            this.receivedAt(other.getReceivedAt());
            this.seriesId(other.getSeriesId());
            this.seriesTitle(other.getSeriesTitle());
            this.nodeId(other.getNodeId());
            this.firstReply(other.getFirstReply());
            this.firstCompletion(other.getFirstCompletion());
            this.firstSeriesCompletion(other.getFirstSeriesCompletion());
            this.firstSeriesDisengagement(other.getFirstSeriesDisengagement());
            this.firstSeriesExit(other.getFirstSeriesExit());
            this.firstGoalSuccess(other.getFirstGoalSuccess());
            this.firstOpen(other.getFirstOpen());
            this.firstClick(other.getFirstClick());
            this.firstDismisall(other.getFirstDismisall());
            this.firstUnsubscribe(other.getFirstUnsubscribe());
            this.firstHardBounce(other.getFirstHardBounce());
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public CompanyIdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public EmailStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public NameStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public RulesetIdStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="ruleset_id")
        public ContentIdStage rulesetId(@NotNull String rulesetId) {
            this.rulesetId = Objects.requireNonNull(rulesetId, "rulesetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content_id")
        public ContentTypeStage contentId(@NotNull String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content_type")
        public ContentTitleStage contentType(@NotNull String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content_title")
        public _FinalStage contentTitle(@NotNull String contentTitle) {
            this.contentTitle = Objects.requireNonNull(contentTitle, "contentTitle must not be null");
            return this;
        }

        @Override
        public _FinalStage firstHardBounce(Integer firstHardBounce) {
            this.firstHardBounce = Optional.ofNullable(firstHardBounce);
            return this;
        }

        @Override
        @JsonSetter(value="first_hard_bounce", nulls=Nulls.SKIP)
        public _FinalStage firstHardBounce(Optional<Integer> firstHardBounce) {
            this.firstHardBounce = firstHardBounce;
            return this;
        }

        @Override
        public _FinalStage firstUnsubscribe(Integer firstUnsubscribe) {
            this.firstUnsubscribe = Optional.ofNullable(firstUnsubscribe);
            return this;
        }

        @Override
        @JsonSetter(value="first_unsubscribe", nulls=Nulls.SKIP)
        public _FinalStage firstUnsubscribe(Optional<Integer> firstUnsubscribe) {
            this.firstUnsubscribe = firstUnsubscribe;
            return this;
        }

        @Override
        public _FinalStage firstDismisall(Integer firstDismisall) {
            this.firstDismisall = Optional.ofNullable(firstDismisall);
            return this;
        }

        @Override
        @JsonSetter(value="first_dismisall", nulls=Nulls.SKIP)
        public _FinalStage firstDismisall(Optional<Integer> firstDismisall) {
            this.firstDismisall = firstDismisall;
            return this;
        }

        @Override
        public _FinalStage firstClick(Integer firstClick) {
            this.firstClick = Optional.ofNullable(firstClick);
            return this;
        }

        @Override
        @JsonSetter(value="first_click", nulls=Nulls.SKIP)
        public _FinalStage firstClick(Optional<Integer> firstClick) {
            this.firstClick = firstClick;
            return this;
        }

        @Override
        public _FinalStage firstOpen(Integer firstOpen) {
            this.firstOpen = Optional.ofNullable(firstOpen);
            return this;
        }

        @Override
        @JsonSetter(value="first_open", nulls=Nulls.SKIP)
        public _FinalStage firstOpen(Optional<Integer> firstOpen) {
            this.firstOpen = firstOpen;
            return this;
        }

        @Override
        public _FinalStage firstGoalSuccess(Integer firstGoalSuccess) {
            this.firstGoalSuccess = Optional.ofNullable(firstGoalSuccess);
            return this;
        }

        @Override
        @JsonSetter(value="first_goal_success", nulls=Nulls.SKIP)
        public _FinalStage firstGoalSuccess(Optional<Integer> firstGoalSuccess) {
            this.firstGoalSuccess = firstGoalSuccess;
            return this;
        }

        @Override
        public _FinalStage firstSeriesExit(Integer firstSeriesExit) {
            this.firstSeriesExit = Optional.ofNullable(firstSeriesExit);
            return this;
        }

        @Override
        @JsonSetter(value="first_series_exit", nulls=Nulls.SKIP)
        public _FinalStage firstSeriesExit(Optional<Integer> firstSeriesExit) {
            this.firstSeriesExit = firstSeriesExit;
            return this;
        }

        @Override
        public _FinalStage firstSeriesDisengagement(Integer firstSeriesDisengagement) {
            this.firstSeriesDisengagement = Optional.ofNullable(firstSeriesDisengagement);
            return this;
        }

        @Override
        @JsonSetter(value="first_series_disengagement", nulls=Nulls.SKIP)
        public _FinalStage firstSeriesDisengagement(Optional<Integer> firstSeriesDisengagement) {
            this.firstSeriesDisengagement = firstSeriesDisengagement;
            return this;
        }

        @Override
        public _FinalStage firstSeriesCompletion(Integer firstSeriesCompletion) {
            this.firstSeriesCompletion = Optional.ofNullable(firstSeriesCompletion);
            return this;
        }

        @Override
        @JsonSetter(value="first_series_completion", nulls=Nulls.SKIP)
        public _FinalStage firstSeriesCompletion(Optional<Integer> firstSeriesCompletion) {
            this.firstSeriesCompletion = firstSeriesCompletion;
            return this;
        }

        @Override
        public _FinalStage firstCompletion(Integer firstCompletion) {
            this.firstCompletion = Optional.ofNullable(firstCompletion);
            return this;
        }

        @Override
        @JsonSetter(value="first_completion", nulls=Nulls.SKIP)
        public _FinalStage firstCompletion(Optional<Integer> firstCompletion) {
            this.firstCompletion = firstCompletion;
            return this;
        }

        @Override
        public _FinalStage firstReply(Integer firstReply) {
            this.firstReply = Optional.ofNullable(firstReply);
            return this;
        }

        @Override
        @JsonSetter(value="first_reply", nulls=Nulls.SKIP)
        public _FinalStage firstReply(Optional<Integer> firstReply) {
            this.firstReply = firstReply;
            return this;
        }

        @Override
        public _FinalStage nodeId(String nodeId) {
            this.nodeId = Optional.ofNullable(nodeId);
            return this;
        }

        @Override
        @JsonSetter(value="node_id", nulls=Nulls.SKIP)
        public _FinalStage nodeId(Optional<String> nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @Override
        public _FinalStage seriesTitle(String seriesTitle) {
            this.seriesTitle = Optional.ofNullable(seriesTitle);
            return this;
        }

        @Override
        @JsonSetter(value="series_title", nulls=Nulls.SKIP)
        public _FinalStage seriesTitle(Optional<String> seriesTitle) {
            this.seriesTitle = seriesTitle;
            return this;
        }

        @Override
        public _FinalStage seriesId(String seriesId) {
            this.seriesId = Optional.ofNullable(seriesId);
            return this;
        }

        @Override
        @JsonSetter(value="series_id", nulls=Nulls.SKIP)
        public _FinalStage seriesId(Optional<String> seriesId) {
            this.seriesId = seriesId;
            return this;
        }

        @Override
        public _FinalStage receivedAt(Integer receivedAt) {
            this.receivedAt = Optional.ofNullable(receivedAt);
            return this;
        }

        @Override
        @JsonSetter(value="received_at", nulls=Nulls.SKIP)
        public _FinalStage receivedAt(Optional<Integer> receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        @Override
        public _FinalStage receiptId(String receiptId) {
            this.receiptId = Optional.ofNullable(receiptId);
            return this;
        }

        @Override
        @JsonSetter(value="receipt_id", nulls=Nulls.SKIP)
        public _FinalStage receiptId(Optional<String> receiptId) {
            this.receiptId = receiptId;
            return this;
        }

        @Override
        public _FinalStage rulesetVersionId(String rulesetVersionId) {
            this.rulesetVersionId = Optional.ofNullable(rulesetVersionId);
            return this;
        }

        @Override
        @JsonSetter(value="ruleset_version_id", nulls=Nulls.SKIP)
        public _FinalStage rulesetVersionId(Optional<String> rulesetVersionId) {
            this.rulesetVersionId = rulesetVersionId;
            return this;
        }

        @Override
        public _FinalStage userExternalId(String userExternalId) {
            this.userExternalId = Optional.ofNullable(userExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="user_external_id", nulls=Nulls.SKIP)
        public _FinalStage userExternalId(Optional<String> userExternalId) {
            this.userExternalId = userExternalId;
            return this;
        }

        @Override
        public DataExportCsv build() {
            return new DataExportCsv(this.userId, this.userExternalId, this.companyId, this.email, this.name, this.rulesetId, this.contentId, this.contentType, this.contentTitle, this.rulesetVersionId, this.receiptId, this.receivedAt, this.seriesId, this.seriesTitle, this.nodeId, this.firstReply, this.firstCompletion, this.firstSeriesCompletion, this.firstSeriesDisengagement, this.firstSeriesExit, this.firstGoalSuccess, this.firstOpen, this.firstClick, this.firstDismisall, this.firstUnsubscribe, this.firstHardBounce, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataExportCsv build();

        public _FinalStage userExternalId(Optional<String> var1);

        public _FinalStage userExternalId(String var1);

        public _FinalStage rulesetVersionId(Optional<String> var1);

        public _FinalStage rulesetVersionId(String var1);

        public _FinalStage receiptId(Optional<String> var1);

        public _FinalStage receiptId(String var1);

        public _FinalStage receivedAt(Optional<Integer> var1);

        public _FinalStage receivedAt(Integer var1);

        public _FinalStage seriesId(Optional<String> var1);

        public _FinalStage seriesId(String var1);

        public _FinalStage seriesTitle(Optional<String> var1);

        public _FinalStage seriesTitle(String var1);

        public _FinalStage nodeId(Optional<String> var1);

        public _FinalStage nodeId(String var1);

        public _FinalStage firstReply(Optional<Integer> var1);

        public _FinalStage firstReply(Integer var1);

        public _FinalStage firstCompletion(Optional<Integer> var1);

        public _FinalStage firstCompletion(Integer var1);

        public _FinalStage firstSeriesCompletion(Optional<Integer> var1);

        public _FinalStage firstSeriesCompletion(Integer var1);

        public _FinalStage firstSeriesDisengagement(Optional<Integer> var1);

        public _FinalStage firstSeriesDisengagement(Integer var1);

        public _FinalStage firstSeriesExit(Optional<Integer> var1);

        public _FinalStage firstSeriesExit(Integer var1);

        public _FinalStage firstGoalSuccess(Optional<Integer> var1);

        public _FinalStage firstGoalSuccess(Integer var1);

        public _FinalStage firstOpen(Optional<Integer> var1);

        public _FinalStage firstOpen(Integer var1);

        public _FinalStage firstClick(Optional<Integer> var1);

        public _FinalStage firstClick(Integer var1);

        public _FinalStage firstDismisall(Optional<Integer> var1);

        public _FinalStage firstDismisall(Integer var1);

        public _FinalStage firstUnsubscribe(Optional<Integer> var1);

        public _FinalStage firstUnsubscribe(Integer var1);

        public _FinalStage firstHardBounce(Optional<Integer> var1);

        public _FinalStage firstHardBounce(Integer var1);
    }

    public static interface ContentTitleStage {
        public _FinalStage contentTitle(@NotNull String var1);
    }

    public static interface ContentTypeStage {
        public ContentTitleStage contentType(@NotNull String var1);
    }

    public static interface ContentIdStage {
        public ContentTypeStage contentId(@NotNull String var1);
    }

    public static interface RulesetIdStage {
        public ContentIdStage rulesetId(@NotNull String var1);
    }

    public static interface NameStage {
        public RulesetIdStage name(@NotNull String var1);
    }

    public static interface EmailStage {
        public NameStage email(@NotNull String var1);
    }

    public static interface CompanyIdStage {
        public EmailStage companyId(@NotNull String var1);
    }

    public static interface UserIdStage {
        public CompanyIdStage userId(@NotNull String var1);

        public Builder from(DataExportCsv var1);
    }
}

