/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataTableItem {
    private final String field;
    private final String value;
    private final Map<String, Object> additionalProperties;

    private DataTableItem(String field, String value, Map<String, Object> additionalProperties) {
        this.field = field;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "field-value";
    }

    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataTableItem && this.equalTo((DataTableItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataTableItem other) {
        return this.field.equals(other.field) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FieldStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FieldStage,
    ValueStage,
    _FinalStage {
        private String field;
        private String value;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataTableItem other) {
            this.field(other.getField());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="field")
        public ValueStage field(@NotNull String field) {
            this.field = Objects.requireNonNull(field, "field must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public DataTableItem build() {
            return new DataTableItem(this.field, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataTableItem build();
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull String var1);
    }

    public static interface FieldStage {
        public ValueStage field(@NotNull String var1);

        public Builder from(DataTableItem var1);
    }
}

