/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DividerComponent {
    private final Optional<String> id;
    private final Optional<String> bottomMargin;
    private final Map<String, Object> additionalProperties;

    private DividerComponent(Optional<String> id, Optional<String> bottomMargin, Map<String, Object> additionalProperties) {
        this.id = id;
        this.bottomMargin = bottomMargin;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="bottom_margin")
    public Optional<String> getBottomMargin() {
        return this.bottomMargin;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DividerComponent && this.equalTo((DividerComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DividerComponent other) {
        return this.id.equals(other.id) && this.bottomMargin.equals(other.bottomMargin);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bottomMargin);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> bottomMargin = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DividerComponent other) {
            this.id(other.getId());
            this.bottomMargin(other.getBottomMargin());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="bottom_margin", nulls=Nulls.SKIP)
        public Builder bottomMargin(Optional<String> bottomMargin) {
            this.bottomMargin = bottomMargin;
            return this;
        }

        public Builder bottomMargin(String bottomMargin) {
            this.bottomMargin = Optional.ofNullable(bottomMargin);
            return this;
        }

        public DividerComponent build() {
            return new DividerComponent(this.id, this.bottomMargin, this.additionalProperties);
        }
    }
}

