/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GroupContent {
    private final String name;
    private final String description;
    private final Map<String, Object> additionalProperties;

    private GroupContent(String name, String description, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "group_content";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GroupContent && this.equalTo((GroupContent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GroupContent other) {
        return this.name.equals(other.name) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    DescriptionStage,
    _FinalStage {
        private String name;
        private String description;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GroupContent other) {
            this.name(other.getName());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public _FinalStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        public GroupContent build() {
            return new GroupContent(this.name, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GroupContent build();
    }

    public static interface DescriptionStage {
        public _FinalStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);

        public Builder from(GroupContent var1);
    }
}

