/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LinkedObject {
    private final Type type;
    private final String id;
    private final Optional<String> category;
    private final Map<String, Object> additionalProperties;

    private LinkedObject(Type type, String id, Optional<String> category, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="category")
    public Optional<String> getCategory() {
        return this.category;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkedObject && this.equalTo((LinkedObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObject other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.category.equals(other.category);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.category);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type TICKET = new Type(Value.TICKET, "ticket");
        public static final Type CONVERSATION = new Type(Value.CONVERSATION, "conversation");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case TICKET: {
                    return visitor.visitTicket();
                }
                case CONVERSATION: {
                    return visitor.visitConversation();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "ticket": {
                    return TICKET;
                }
                case "conversation": {
                    return CONVERSATION;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitTicket();

            public T visitConversation();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            TICKET,
            CONVERSATION,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    _FinalStage {
        private Type type;
        private String id;
        private Optional<String> category = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LinkedObject other) {
            this.type(other.getType());
            this.id(other.getId());
            this.category(other.getCategory());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage category(String category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        @Override
        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public _FinalStage category(Optional<String> category) {
            this.category = category;
            return this;
        }

        @Override
        public LinkedObject build() {
            return new LinkedObject(this.type, this.id, this.category, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LinkedObject build();

        public _FinalStage category(Optional<String> var1);

        public _FinalStage category(String var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull Type var1);

        public Builder from(LinkedObject var1);
    }
}

