/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.LinkedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LinkedObjectList {
    private final int totalCount;
    private final boolean hasMore;
    private final List<LinkedObject> data;
    private final Map<String, Object> additionalProperties;

    private LinkedObjectList(int totalCount, boolean hasMore, List<LinkedObject> data, Map<String, Object> additionalProperties) {
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="has_more")
    public boolean getHasMore() {
        return this.hasMore;
    }

    @JsonProperty(value="data")
    public List<LinkedObject> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkedObjectList && this.equalTo((LinkedObjectList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObjectList other) {
        return this.totalCount == other.totalCount && this.hasMore == other.hasMore && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.hasMore, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    HasMoreStage,
    _FinalStage {
        private int totalCount;
        private boolean hasMore;
        private List<LinkedObject> data = new ArrayList<LinkedObject>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LinkedObjectList other) {
            this.totalCount(other.getTotalCount());
            this.hasMore(other.getHasMore());
            this.data(other.getData());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public HasMoreStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        @JsonSetter(value="has_more")
        public _FinalStage hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        @Override
        public _FinalStage addAllData(List<LinkedObject> data) {
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage addData(LinkedObject data) {
            this.data.add(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(List<LinkedObject> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @Override
        public LinkedObjectList build() {
            return new LinkedObjectList(this.totalCount, this.hasMore, this.data, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LinkedObjectList build();

        public _FinalStage data(List<LinkedObject> var1);

        public _FinalStage addData(LinkedObject var1);

        public _FinalStage addAllData(List<LinkedObject> var1);
    }

    public static interface HasMoreStage {
        public _FinalStage hasMore(boolean var1);
    }

    public static interface TotalCountStage {
        public HasMoreStage totalCount(int var1);

        public Builder from(LinkedObjectList var1);
    }
}

