/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SlaApplied {
    private final String type;
    private final String slaName;
    private final SlaStatus slaStatus;
    private final Map<String, Object> additionalProperties;

    private SlaApplied(String type, String slaName, SlaStatus slaStatus, Map<String, Object> additionalProperties) {
        this.type = type;
        this.slaName = slaName;
        this.slaStatus = slaStatus;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="sla_name")
    public String getSlaName() {
        return this.slaName;
    }

    @JsonProperty(value="sla_status")
    public SlaStatus getSlaStatus() {
        return this.slaStatus;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SlaApplied && this.equalTo((SlaApplied)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SlaApplied other) {
        return this.type.equals(other.type) && this.slaName.equals(other.slaName) && this.slaStatus.equals(other.slaStatus);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.slaName, this.slaStatus);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class SlaStatus {
        public static final SlaStatus HIT = new SlaStatus(Value.HIT, "hit");
        public static final SlaStatus CANCELLED = new SlaStatus(Value.CANCELLED, "cancelled");
        public static final SlaStatus ACTIVE = new SlaStatus(Value.ACTIVE, "active");
        public static final SlaStatus MISSED = new SlaStatus(Value.MISSED, "missed");
        private final Value value;
        private final String string;

        SlaStatus(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SlaStatus && this.string.equals(((SlaStatus)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case HIT: {
                    return visitor.visitHit();
                }
                case CANCELLED: {
                    return visitor.visitCancelled();
                }
                case ACTIVE: {
                    return visitor.visitActive();
                }
                case MISSED: {
                    return visitor.visitMissed();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SlaStatus valueOf(String value) {
            switch (value) {
                case "hit": {
                    return HIT;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "active": {
                    return ACTIVE;
                }
                case "missed": {
                    return MISSED;
                }
            }
            return new SlaStatus(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitHit();

            public T visitMissed();

            public T visitCancelled();

            public T visitActive();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            HIT,
            MISSED,
            CANCELLED,
            ACTIVE,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    SlaNameStage,
    SlaStatusStage,
    _FinalStage {
        private String type;
        private String slaName;
        private SlaStatus slaStatus;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SlaApplied other) {
            this.type(other.getType());
            this.slaName(other.getSlaName());
            this.slaStatus(other.getSlaStatus());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public SlaNameStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="sla_name")
        public SlaStatusStage slaName(@NotNull String slaName) {
            this.slaName = Objects.requireNonNull(slaName, "slaName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="sla_status")
        public _FinalStage slaStatus(@NotNull SlaStatus slaStatus) {
            this.slaStatus = Objects.requireNonNull(slaStatus, "slaStatus must not be null");
            return this;
        }

        @Override
        public SlaApplied build() {
            return new SlaApplied(this.type, this.slaName, this.slaStatus, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SlaApplied build();
    }

    public static interface SlaStatusStage {
        public _FinalStage slaStatus(@NotNull SlaStatus var1);
    }

    public static interface SlaNameStage {
        public SlaStatusStage slaName(@NotNull String var1);
    }

    public static interface TypeStage {
        public SlaNameStage type(@NotNull String var1);

        public Builder from(SlaApplied var1);
    }
}

