/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SnoozeConversationRequest {
    private final String adminId;
    private final int snoozedUntil;
    private final Map<String, Object> additionalProperties;

    private SnoozeConversationRequest(String adminId, int snoozedUntil, Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.snoozedUntil = snoozedUntil;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="snoozed_until")
    public int getSnoozedUntil() {
        return this.snoozedUntil;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SnoozeConversationRequest && this.equalTo((SnoozeConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SnoozeConversationRequest other) {
        return this.adminId.equals(other.adminId) && this.snoozedUntil == other.snoozedUntil;
    }

    public int hashCode() {
        return Objects.hash(this.adminId, this.snoozedUntil);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AdminIdStage,
    SnoozedUntilStage,
    _FinalStage {
        private String adminId;
        private int snoozedUntil;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SnoozeConversationRequest other) {
            this.adminId(other.getAdminId());
            this.snoozedUntil(other.getSnoozedUntil());
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public SnoozedUntilStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="snoozed_until")
        public _FinalStage snoozedUntil(int snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        @Override
        public SnoozeConversationRequest build() {
            return new SnoozeConversationRequest(this.adminId, this.snoozedUntil, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SnoozeConversationRequest build();
    }

    public static interface SnoozedUntilStage {
        public _FinalStage snoozedUntil(int var1);
    }

    public static interface AdminIdStage {
        public SnoozedUntilStage adminId(@NotNull String var1);

        public Builder from(SnoozeConversationRequest var1);
    }
}

