/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.types.Context;
import com.intercom.api.types.CurrentCanvas;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubmitRequest {
    private final String workspaceId;
    private final String workspaceRegion;
    private final Admin admin;
    private final String componentId;
    private final Context context;
    private final Conversation conversation;
    private final CurrentCanvas currentCanvas;
    private final Contact contact;
    private final Map<String, Object> inputValues;
    private final Contact user;
    private final Map<String, Object> additionalProperties;

    private SubmitRequest(String workspaceId, String workspaceRegion, Admin admin, String componentId, Context context, Conversation conversation, CurrentCanvas currentCanvas, Contact contact, Map<String, Object> inputValues, Contact user, Map<String, Object> additionalProperties) {
        this.workspaceId = workspaceId;
        this.workspaceRegion = workspaceRegion;
        this.admin = admin;
        this.componentId = componentId;
        this.context = context;
        this.conversation = conversation;
        this.currentCanvas = currentCanvas;
        this.contact = contact;
        this.inputValues = inputValues;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspace_region")
    public String getWorkspaceRegion() {
        return this.workspaceRegion;
    }

    @JsonProperty(value="admin")
    public Admin getAdmin() {
        return this.admin;
    }

    @JsonProperty(value="component_id")
    public String getComponentId() {
        return this.componentId;
    }

    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="conversation")
    public Conversation getConversation() {
        return this.conversation;
    }

    @JsonProperty(value="current_canvas")
    public CurrentCanvas getCurrentCanvas() {
        return this.currentCanvas;
    }

    @JsonProperty(value="contact")
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="input_values")
    public Map<String, Object> getInputValues() {
        return this.inputValues;
    }

    @JsonProperty(value="user")
    public Contact getUser() {
        return this.user;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubmitRequest && this.equalTo((SubmitRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubmitRequest other) {
        return this.workspaceId.equals(other.workspaceId) && this.workspaceRegion.equals(other.workspaceRegion) && this.admin.equals(other.admin) && this.componentId.equals(other.componentId) && this.context.equals(other.context) && this.conversation.equals(other.conversation) && this.currentCanvas.equals(other.currentCanvas) && this.contact.equals(other.contact) && this.inputValues.equals(other.inputValues) && this.user.equals(other.user);
    }

    public int hashCode() {
        return Objects.hash(this.workspaceId, this.workspaceRegion, this.admin, this.componentId, this.context, this.conversation, this.currentCanvas, this.contact, this.inputValues, this.user);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WorkspaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WorkspaceIdStage,
    WorkspaceRegionStage,
    AdminStage,
    ComponentIdStage,
    ContextStage,
    ConversationStage,
    CurrentCanvasStage,
    ContactStage,
    UserStage,
    _FinalStage {
        private String workspaceId;
        private String workspaceRegion;
        private Admin admin;
        private String componentId;
        private Context context;
        private Conversation conversation;
        private CurrentCanvas currentCanvas;
        private Contact contact;
        private Contact user;
        private Map<String, Object> inputValues = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SubmitRequest other) {
            this.workspaceId(other.getWorkspaceId());
            this.workspaceRegion(other.getWorkspaceRegion());
            this.admin(other.getAdmin());
            this.componentId(other.getComponentId());
            this.context(other.getContext());
            this.conversation(other.getConversation());
            this.currentCanvas(other.getCurrentCanvas());
            this.contact(other.getContact());
            this.inputValues(other.getInputValues());
            this.user(other.getUser());
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_region")
        public AdminStage workspaceRegion(@NotNull String workspaceRegion) {
            this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin")
        public ComponentIdStage admin(@NotNull Admin admin) {
            this.admin = Objects.requireNonNull(admin, "admin must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="component_id")
        public ContextStage componentId(@NotNull String componentId) {
            this.componentId = Objects.requireNonNull(componentId, "componentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="context")
        public ConversationStage context(@NotNull Context context) {
            this.context = Objects.requireNonNull(context, "context must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="conversation")
        public CurrentCanvasStage conversation(@NotNull Conversation conversation) {
            this.conversation = Objects.requireNonNull(conversation, "conversation must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="current_canvas")
        public ContactStage currentCanvas(@NotNull CurrentCanvas currentCanvas) {
            this.currentCanvas = Objects.requireNonNull(currentCanvas, "currentCanvas must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contact")
        public UserStage contact(@NotNull Contact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user")
        public _FinalStage user(@NotNull Contact user) {
            this.user = Objects.requireNonNull(user, "user must not be null");
            return this;
        }

        @Override
        public _FinalStage inputValues(String key, Object value) {
            this.inputValues.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllInputValues(Map<String, Object> inputValues) {
            this.inputValues.putAll(inputValues);
            return this;
        }

        @Override
        @JsonSetter(value="input_values", nulls=Nulls.SKIP)
        public _FinalStage inputValues(Map<String, Object> inputValues) {
            this.inputValues.clear();
            this.inputValues.putAll(inputValues);
            return this;
        }

        @Override
        public SubmitRequest build() {
            return new SubmitRequest(this.workspaceId, this.workspaceRegion, this.admin, this.componentId, this.context, this.conversation, this.currentCanvas, this.contact, this.inputValues, this.user, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SubmitRequest build();

        public _FinalStage inputValues(Map<String, Object> var1);

        public _FinalStage putAllInputValues(Map<String, Object> var1);

        public _FinalStage inputValues(String var1, Object var2);
    }

    public static interface UserStage {
        public _FinalStage user(@NotNull Contact var1);
    }

    public static interface ContactStage {
        public UserStage contact(@NotNull Contact var1);
    }

    public static interface CurrentCanvasStage {
        public ContactStage currentCanvas(@NotNull CurrentCanvas var1);
    }

    public static interface ConversationStage {
        public CurrentCanvasStage conversation(@NotNull Conversation var1);
    }

    public static interface ContextStage {
        public ConversationStage context(@NotNull Context var1);
    }

    public static interface ComponentIdStage {
        public ContextStage componentId(@NotNull String var1);
    }

    public static interface AdminStage {
        public ComponentIdStage admin(@NotNull Admin var1);
    }

    public static interface WorkspaceRegionStage {
        public AdminStage workspaceRegion(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public WorkspaceRegionStage workspaceId(@NotNull String var1);

        public Builder from(SubmitRequest var1);
    }
}

