/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CanvasObject;
import com.intercom.api.types.Event;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubmitResponse {
    private final CanvasObject canvas;
    private final Optional<Map<String, Object>> cardCreationOptions;
    private final Optional<Event> event;
    private final Map<String, Object> additionalProperties;

    private SubmitResponse(CanvasObject canvas, Optional<Map<String, Object>> cardCreationOptions, Optional<Event> event, Map<String, Object> additionalProperties) {
        this.canvas = canvas;
        this.cardCreationOptions = cardCreationOptions;
        this.event = event;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="canvas")
    public CanvasObject getCanvas() {
        return this.canvas;
    }

    @JsonProperty(value="card_creation_options")
    public Optional<Map<String, Object>> getCardCreationOptions() {
        return this.cardCreationOptions;
    }

    @JsonProperty(value="event")
    public Optional<Event> getEvent() {
        return this.event;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubmitResponse && this.equalTo((SubmitResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubmitResponse other) {
        return this.canvas.equals(other.canvas) && this.cardCreationOptions.equals(other.cardCreationOptions) && this.event.equals(other.event);
    }

    public int hashCode() {
        return Objects.hash(this.canvas, this.cardCreationOptions, this.event);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CanvasStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CanvasStage,
    _FinalStage {
        private CanvasObject canvas;
        private Optional<Event> event = Optional.empty();
        private Optional<Map<String, Object>> cardCreationOptions = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SubmitResponse other) {
            this.canvas(other.getCanvas());
            this.cardCreationOptions(other.getCardCreationOptions());
            this.event(other.getEvent());
            return this;
        }

        @Override
        @JsonSetter(value="canvas")
        public _FinalStage canvas(@NotNull CanvasObject canvas) {
            this.canvas = Objects.requireNonNull(canvas, "canvas must not be null");
            return this;
        }

        @Override
        public _FinalStage event(Event event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        @Override
        @JsonSetter(value="event", nulls=Nulls.SKIP)
        public _FinalStage event(Optional<Event> event) {
            this.event = event;
            return this;
        }

        @Override
        public _FinalStage cardCreationOptions(Map<String, Object> cardCreationOptions) {
            this.cardCreationOptions = Optional.ofNullable(cardCreationOptions);
            return this;
        }

        @Override
        @JsonSetter(value="card_creation_options", nulls=Nulls.SKIP)
        public _FinalStage cardCreationOptions(Optional<Map<String, Object>> cardCreationOptions) {
            this.cardCreationOptions = cardCreationOptions;
            return this;
        }

        @Override
        public SubmitResponse build() {
            return new SubmitResponse(this.canvas, this.cardCreationOptions, this.event, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SubmitResponse build();

        public _FinalStage cardCreationOptions(Optional<Map<String, Object>> var1);

        public _FinalStage cardCreationOptions(Map<String, Object> var1);

        public _FinalStage event(Optional<Event> var1);

        public _FinalStage event(Event var1);
    }

    public static interface CanvasStage {
        public _FinalStage canvas(@NotNull CanvasObject var1);

        public Builder from(SubmitResponse var1);
    }
}

