/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.teams.types.Team;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TeamList {
    private final List<Team> teams;
    private final Map<String, Object> additionalProperties;

    private TeamList(List<Team> teams, Map<String, Object> additionalProperties) {
        this.teams = teams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "team.list";
    }

    @JsonProperty(value="teams")
    public List<Team> getTeams() {
        return this.teams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TeamList && this.equalTo((TeamList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeamList other) {
        return this.teams.equals(other.teams);
    }

    public int hashCode() {
        return Objects.hash(this.teams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Team> teams = new ArrayList<Team>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TeamList other) {
            this.teams(other.getTeams());
            return this;
        }

        @JsonSetter(value="teams", nulls=Nulls.SKIP)
        public Builder teams(List<Team> teams) {
            this.teams.clear();
            this.teams.addAll(teams);
            return this;
        }

        public Builder addTeams(Team teams) {
            this.teams.add(teams);
            return this;
        }

        public Builder addAllTeams(List<Team> teams) {
            this.teams.addAll(teams);
            return this;
        }

        public TeamList build() {
            return new TeamList(this.teams, this.additionalProperties);
        }
    }
}

