/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TextComponent {
    private final Optional<String> id;
    private final String text;
    private final Optional<Align> align;
    private final Optional<Style> style;
    private final Optional<String> bottomMargin;
    private final Map<String, Object> additionalProperties;

    private TextComponent(Optional<String> id, String text, Optional<Align> align, Optional<Style> style, Optional<String> bottomMargin, Map<String, Object> additionalProperties) {
        this.id = id;
        this.text = text;
        this.align = align;
        this.style = style;
        this.bottomMargin = bottomMargin;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="align")
    public Optional<Align> getAlign() {
        return this.align;
    }

    @JsonProperty(value="style")
    public Optional<Style> getStyle() {
        return this.style;
    }

    @JsonProperty(value="bottom_margin")
    public Optional<String> getBottomMargin() {
        return this.bottomMargin;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TextComponent && this.equalTo((TextComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TextComponent other) {
        return this.id.equals(other.id) && this.text.equals(other.text) && this.align.equals(other.align) && this.style.equals(other.style) && this.bottomMargin.equals(other.bottomMargin);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.align, this.style, this.bottomMargin);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    public static final class Align {
        public static final Align LEFT = new Align(Value.LEFT, "left");
        public static final Align RIGHT = new Align(Value.RIGHT, "right");
        public static final Align CENTER = new Align(Value.CENTER, "center");
        private final Value value;
        private final String string;

        Align(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Align && this.string.equals(((Align)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LEFT: {
                    return visitor.visitLeft();
                }
                case RIGHT: {
                    return visitor.visitRight();
                }
                case CENTER: {
                    return visitor.visitCenter();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Align valueOf(String value) {
            switch (value) {
                case "left": {
                    return LEFT;
                }
                case "right": {
                    return RIGHT;
                }
                case "center": {
                    return CENTER;
                }
            }
            return new Align(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitLeft();

            public T visitCenter();

            public T visitRight();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            LEFT,
            CENTER,
            RIGHT,
            UNKNOWN;

        }
    }

    public static final class Style {
        public static final Style MUTED = new Style(Value.MUTED, "muted");
        public static final Style HEADER = new Style(Value.HEADER, "header");
        public static final Style PARAGRAPH = new Style(Value.PARAGRAPH, "paragraph");
        public static final Style ERROR = new Style(Value.ERROR, "error");
        private final Value value;
        private final String string;

        Style(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Style && this.string.equals(((Style)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case MUTED: {
                    return visitor.visitMuted();
                }
                case HEADER: {
                    return visitor.visitHeader();
                }
                case PARAGRAPH: {
                    return visitor.visitParagraph();
                }
                case ERROR: {
                    return visitor.visitError();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Style valueOf(String value) {
            switch (value) {
                case "muted": {
                    return MUTED;
                }
                case "header": {
                    return HEADER;
                }
                case "paragraph": {
                    return PARAGRAPH;
                }
                case "error": {
                    return ERROR;
                }
            }
            return new Style(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitHeader();

            public T visitParagraph();

            public T visitMuted();

            public T visitError();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            HEADER,
            PARAGRAPH,
            MUTED,
            ERROR,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    _FinalStage {
        private String text;
        private Optional<String> bottomMargin = Optional.empty();
        private Optional<Style> style = Optional.empty();
        private Optional<Align> align = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TextComponent other) {
            this.id(other.getId());
            this.text(other.getText());
            this.align(other.getAlign());
            this.style(other.getStyle());
            this.bottomMargin(other.getBottomMargin());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        @Override
        public _FinalStage bottomMargin(String bottomMargin) {
            this.bottomMargin = Optional.ofNullable(bottomMargin);
            return this;
        }

        @Override
        @JsonSetter(value="bottom_margin", nulls=Nulls.SKIP)
        public _FinalStage bottomMargin(Optional<String> bottomMargin) {
            this.bottomMargin = bottomMargin;
            return this;
        }

        @Override
        public _FinalStage style(Style style) {
            this.style = Optional.ofNullable(style);
            return this;
        }

        @Override
        @JsonSetter(value="style", nulls=Nulls.SKIP)
        public _FinalStage style(Optional<Style> style) {
            this.style = style;
            return this;
        }

        @Override
        public _FinalStage align(Align align) {
            this.align = Optional.ofNullable(align);
            return this;
        }

        @Override
        @JsonSetter(value="align", nulls=Nulls.SKIP)
        public _FinalStage align(Optional<Align> align) {
            this.align = align;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public TextComponent build() {
            return new TextComponent(this.id, this.text, this.align, this.style, this.bottomMargin, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TextComponent build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage align(Optional<Align> var1);

        public _FinalStage align(Align var1);

        public _FinalStage style(Optional<Style> var1);

        public _FinalStage style(Style var1);

        public _FinalStage bottomMargin(Optional<String> var1);

        public _FinalStage bottomMargin(String var1);
    }

    public static interface TextStage {
        public _FinalStage text(@NotNull String var1);

        public Builder from(TextComponent var1);
    }
}

