/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketParts {
    private final List<TicketPart> ticketParts;
    private final int totalCount;
    private final Map<String, Object> additionalProperties;

    private TicketParts(List<TicketPart> ticketParts, int totalCount, Map<String, Object> additionalProperties) {
        this.ticketParts = ticketParts;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket_part.list";
    }

    @JsonProperty(value="ticket_parts")
    public List<TicketPart> getTicketParts() {
        return this.ticketParts;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketParts && this.equalTo((TicketParts)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketParts other) {
        return this.ticketParts.equals(other.ticketParts) && this.totalCount == other.totalCount;
    }

    public int hashCode() {
        return Objects.hash(this.ticketParts, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<TicketPart> ticketParts = new ArrayList<TicketPart>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketParts other) {
            this.ticketParts(other.getTicketParts());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllTicketParts(List<TicketPart> ticketParts) {
            this.ticketParts.addAll(ticketParts);
            return this;
        }

        @Override
        public _FinalStage addTicketParts(TicketPart ticketParts) {
            this.ticketParts.add(ticketParts);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_parts", nulls=Nulls.SKIP)
        public _FinalStage ticketParts(List<TicketPart> ticketParts) {
            this.ticketParts.clear();
            this.ticketParts.addAll(ticketParts);
            return this;
        }

        @Override
        public TicketParts build() {
            return new TicketParts(this.ticketParts, this.totalCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketParts build();

        public _FinalStage ticketParts(List<TicketPart> var1);

        public _FinalStage addTicketParts(TicketPart var1);

        public _FinalStage addAllTicketParts(List<TicketPart> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(TicketParts var1);
    }
}

