/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CursorPages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleSearchResponse.Builder.class)
public final class ArticleSearchResponse {
    private final Optional<String> type;

    private final Optional<Integer> totalCount;

    private final Optional<Data> data;

    private final Optional<CursorPages> pages;

    private final Map<String, Object> additionalProperties;

    private ArticleSearchResponse(
            Optional<String> type,
            Optional<Integer> totalCount,
            Optional<Data> data,
            Optional<CursorPages> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.totalCount = totalCount;
        this.data = data;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - <code>list</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The total number of Articles matching the search query
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return An object containing the results of the search.
     */
    @JsonProperty("data")
    public Optional<Data> getData() {
        return data;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleSearchResponse && equalTo((ArticleSearchResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleSearchResponse other) {
        return type.equals(other.type)
                && totalCount.equals(other.totalCount)
                && data.equals(other.data)
                && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.totalCount, this.data, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<Data> data = Optional.empty();

        private Optional<CursorPages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ArticleSearchResponse other) {
            type(other.getType());
            totalCount(other.getTotalCount());
            data(other.getData());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>The type of the object - <code>list</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The total number of Articles matching the search query</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>An object containing the results of the search.</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<Data> data) {
            this.data = data;
            return this;
        }

        public Builder data(Data data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public ArticleSearchResponse build() {
            return new ArticleSearchResponse(type, totalCount, data, pages, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Data.Builder.class)
    public static final class Data {
        private final Optional<List<Article>> articles;

        private final Optional<List<ArticleSearchHighlights>> highlights;

        private final Map<String, Object> additionalProperties;

        private Data(
                Optional<List<Article>> articles,
                Optional<List<ArticleSearchHighlights>> highlights,
                Map<String, Object> additionalProperties) {
            this.articles = articles;
            this.highlights = highlights;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return An array of Article objects
         */
        @JsonProperty("articles")
        public Optional<List<Article>> getArticles() {
            return articles;
        }

        /**
         * @return A corresponding array of highlighted Article content
         */
        @JsonProperty("highlights")
        public Optional<List<ArticleSearchHighlights>> getHighlights() {
            return highlights;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Data && equalTo((Data) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Data other) {
            return articles.equals(other.articles) && highlights.equals(other.highlights);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.articles, this.highlights);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<List<Article>> articles = Optional.empty();

            private Optional<List<ArticleSearchHighlights>> highlights = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Data other) {
                articles(other.getArticles());
                highlights(other.getHighlights());
                return this;
            }

            /**
             * <p>An array of Article objects</p>
             */
            @JsonSetter(value = "articles", nulls = Nulls.SKIP)
            public Builder articles(Optional<List<Article>> articles) {
                this.articles = articles;
                return this;
            }

            public Builder articles(List<Article> articles) {
                this.articles = Optional.ofNullable(articles);
                return this;
            }

            /**
             * <p>A corresponding array of highlighted Article content</p>
             */
            @JsonSetter(value = "highlights", nulls = Nulls.SKIP)
            public Builder highlights(Optional<List<ArticleSearchHighlights>> highlights) {
                this.highlights = highlights;
                return this;
            }

            public Builder highlights(List<ArticleSearchHighlights> highlights) {
                this.highlights = Optional.ofNullable(highlights);
                return this;
            }

            public Data build() {
                return new Data(articles, highlights, additionalProperties);
            }
        }
    }
}
