/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CustomObjectInstanceList;
import com.intercom.api.types.Datetime;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateConversationRequest.Builder.class)
public final class UpdateConversationRequest {
    private final String conversationId;

    private final Optional<String> displayAs;

    private final Optional<Boolean> read;

    private final Optional<String> title;

    private final Optional<Map<String, CustomAttributesValue>> customAttributes;

    private final Optional<String> companyId;

    private final Map<String, Object> additionalProperties;

    private UpdateConversationRequest(
            String conversationId,
            Optional<String> displayAs,
            Optional<Boolean> read,
            Optional<String> title,
            Optional<Map<String, CustomAttributesValue>> customAttributes,
            Optional<String> companyId,
            Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.displayAs = displayAs;
        this.read = read;
        this.title = title;
        this.customAttributes = customAttributes;
        this.companyId = companyId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the conversation to target
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    /**
     * @return Set to plaintext to retrieve conversation messages in plain text.
     */
    @JsonProperty("display_as")
    public Optional<String> getDisplayAs() {
        return displayAs;
    }

    /**
     * @return Mark a conversation as read within Intercom.
     */
    @JsonProperty("read")
    public Optional<Boolean> getRead() {
        return read;
    }

    /**
     * @return The title given to the conversation
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    @JsonProperty("custom_attributes")
    public Optional<Map<String, CustomAttributesValue>> getCustomAttributes() {
        return customAttributes;
    }

    /**
     * @return The ID of the company that the conversation is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateConversationRequest && equalTo((UpdateConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateConversationRequest other) {
        return conversationId.equals(other.conversationId)
                && displayAs.equals(other.displayAs)
                && read.equals(other.read)
                && title.equals(other.title)
                && customAttributes.equals(other.customAttributes)
                && companyId.equals(other.companyId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.conversationId, this.displayAs, this.read, this.title, this.customAttributes, this.companyId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * <p>The id of the conversation to target</p>
         */
        _FinalStage conversationId(@NotNull String conversationId);

        Builder from(UpdateConversationRequest other);
    }

    public interface _FinalStage {
        UpdateConversationRequest build();

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text.</p>
         */
        _FinalStage displayAs(Optional<String> displayAs);

        _FinalStage displayAs(String displayAs);

        /**
         * <p>Mark a conversation as read within Intercom.</p>
         */
        _FinalStage read(Optional<Boolean> read);

        _FinalStage read(Boolean read);

        /**
         * <p>The title given to the conversation</p>
         */
        _FinalStage title(Optional<String> title);

        _FinalStage title(String title);

        _FinalStage customAttributes(Optional<Map<String, CustomAttributesValue>> customAttributes);

        _FinalStage customAttributes(Map<String, CustomAttributesValue> customAttributes);

        /**
         * <p>The ID of the company that the conversation is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.</p>
         */
        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, _FinalStage {
        private String conversationId;

        private Optional<String> companyId = Optional.empty();

        private Optional<Map<String, CustomAttributesValue>> customAttributes = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<Boolean> read = Optional.empty();

        private Optional<String> displayAs = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateConversationRequest other) {
            conversationId(other.getConversationId());
            displayAs(other.getDisplayAs());
            read(other.getRead());
            title(other.getTitle());
            customAttributes(other.getCustomAttributes());
            companyId(other.getCompanyId());
            return this;
        }

        /**
         * <p>The id of the conversation to target</p>
         * <p>The id of the conversation to target</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        /**
         * <p>The ID of the company that the conversation is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>The ID of the company that the conversation is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public _FinalStage customAttributes(Map<String, CustomAttributesValue> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, CustomAttributesValue>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * <p>The title given to the conversation</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The title given to the conversation</p>
         */
        @java.lang.Override
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public _FinalStage title(Optional<String> title) {
            this.title = title;
            return this;
        }

        /**
         * <p>Mark a conversation as read within Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage read(Boolean read) {
            this.read = Optional.ofNullable(read);
            return this;
        }

        /**
         * <p>Mark a conversation as read within Intercom.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "read", nulls = Nulls.SKIP)
        public _FinalStage read(Optional<Boolean> read) {
            this.read = read;
            return this;
        }

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "display_as", nulls = Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @java.lang.Override
        public UpdateConversationRequest build() {
            return new UpdateConversationRequest(
                    conversationId, displayAs, read, title, customAttributes, companyId, additionalProperties);
        }
    }

    @JsonDeserialize(using = CustomAttributesValue.Deserializer.class)
    public static final class CustomAttributesValue {
        private final Object value;

        private final int type;

        private CustomAttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((String) this.value);
            } else if (this.type == 1) {
                return visitor.visit((int) this.value);
            } else if (this.type == 2) {
                return visitor.visit((Datetime) this.value);
            } else if (this.type == 3) {
                return visitor.visit((CustomObjectInstanceList) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof CustomAttributesValue && equalTo((CustomAttributesValue) other);
        }

        private boolean equalTo(CustomAttributesValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static CustomAttributesValue of(String value) {
            return new CustomAttributesValue(value, 0);
        }

        public static CustomAttributesValue of(int value) {
            return new CustomAttributesValue(value, 1);
        }

        public static CustomAttributesValue of(Datetime value) {
            return new CustomAttributesValue(value, 2);
        }

        public static CustomAttributesValue of(CustomObjectInstanceList value) {
            return new CustomAttributesValue(value, 3);
        }

        public interface Visitor<T> {
            T visit(String value);

            T visit(int value);

            T visit(Datetime value);

            T visit(CustomObjectInstanceList value);
        }

        static final class Deserializer extends StdDeserializer<CustomAttributesValue> {
            Deserializer() {
                super(CustomAttributesValue.class);
            }

            @java.lang.Override
            public CustomAttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                } catch (RuntimeException e) {
                }
                if (value instanceof Integer) {
                    return of((Integer) value);
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, Datetime.class));
                } catch (RuntimeException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, CustomObjectInstanceList.class));
                } catch (RuntimeException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
