/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.customchannelevents.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CustomChannelAttribute;
import com.intercom.api.types.CustomChannelContact;
import com.intercom.api.types.ICustomChannelBaseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NotifyAttributeCollectedRequest.Builder.class)
public final class NotifyAttributeCollectedRequest implements ICustomChannelBaseEvent {
    private final String eventId;

    private final String externalConversationId;

    private final CustomChannelContact contact;

    private final CustomChannelAttribute attribute;

    private final Map<String, Object> additionalProperties;

    private NotifyAttributeCollectedRequest(
            String eventId,
            String externalConversationId,
            CustomChannelContact contact,
            CustomChannelAttribute attribute,
            Map<String, Object> additionalProperties) {
        this.eventId = eventId;
        this.externalConversationId = externalConversationId;
        this.contact = contact;
        this.attribute = attribute;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Unique identifier for the event.
     */
    @JsonProperty("event_id")
    public String getEventId() {
        return eventId;
    }

    /**
     * @return Identifier for the conversation in your application.
     */
    @JsonProperty("external_conversation_id")
    public String getExternalConversationId() {
        return externalConversationId;
    }

    @JsonProperty("contact")
    public CustomChannelContact getContact() {
        return contact;
    }

    @JsonProperty("attribute")
    public CustomChannelAttribute getAttribute() {
        return attribute;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NotifyAttributeCollectedRequest && equalTo((NotifyAttributeCollectedRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NotifyAttributeCollectedRequest other) {
        return eventId.equals(other.eventId)
                && externalConversationId.equals(other.externalConversationId)
                && contact.equals(other.contact)
                && attribute.equals(other.attribute);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.eventId, this.externalConversationId, this.contact, this.attribute);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventIdStage builder() {
        return new Builder();
    }

    public interface EventIdStage {
        /**
         * <p>Unique identifier for the event.</p>
         */
        ExternalConversationIdStage eventId(@NotNull String eventId);

        Builder from(NotifyAttributeCollectedRequest other);
    }

    public interface ExternalConversationIdStage {
        /**
         * <p>Identifier for the conversation in your application.</p>
         */
        ContactStage externalConversationId(@NotNull String externalConversationId);
    }

    public interface ContactStage {
        AttributeStage contact(@NotNull CustomChannelContact contact);
    }

    public interface AttributeStage {
        _FinalStage attribute(@NotNull CustomChannelAttribute attribute);
    }

    public interface _FinalStage {
        NotifyAttributeCollectedRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements EventIdStage, ExternalConversationIdStage, ContactStage, AttributeStage, _FinalStage {
        private String eventId;

        private String externalConversationId;

        private CustomChannelContact contact;

        private CustomChannelAttribute attribute;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(NotifyAttributeCollectedRequest other) {
            eventId(other.getEventId());
            externalConversationId(other.getExternalConversationId());
            contact(other.getContact());
            attribute(other.getAttribute());
            return this;
        }

        /**
         * <p>Unique identifier for the event.</p>
         * <p>Unique identifier for the event.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("event_id")
        public ExternalConversationIdStage eventId(@NotNull String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId must not be null");
            return this;
        }

        /**
         * <p>Identifier for the conversation in your application.</p>
         * <p>Identifier for the conversation in your application.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_conversation_id")
        public ContactStage externalConversationId(@NotNull String externalConversationId) {
            this.externalConversationId =
                    Objects.requireNonNull(externalConversationId, "externalConversationId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("contact")
        public AttributeStage contact(@NotNull CustomChannelContact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("attribute")
        public _FinalStage attribute(@NotNull CustomChannelAttribute attribute) {
            this.attribute = Objects.requireNonNull(attribute, "attribute must not be null");
            return this;
        }

        @java.lang.Override
        public NotifyAttributeCollectedRequest build() {
            return new NotifyAttributeCollectedRequest(
                    eventId, externalConversationId, contact, attribute, additionalProperties);
        }
    }
}
