/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.ipallowlist;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.types.IpAllowlist;
import java.util.concurrent.CompletableFuture;

public class AsyncIpAllowlistClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawIpAllowlistClient rawClient;

    public AsyncIpAllowlistClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawIpAllowlistClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawIpAllowlistClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve the current IP allowlist configuration for the workspace.
     */
    public CompletableFuture<IpAllowlist> getIpAllowlist() {
        return this.rawClient.getIpAllowlist().thenApply(response -> response.body());
    }

    /**
     * Retrieve the current IP allowlist configuration for the workspace.
     */
    public CompletableFuture<IpAllowlist> getIpAllowlist(RequestOptions requestOptions) {
        return this.rawClient.getIpAllowlist(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IpAllowlist> updateIpAllowlist() {
        return this.rawClient.updateIpAllowlist().thenApply(response -> response.body());
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IpAllowlist> updateIpAllowlist(IpAllowlist request) {
        return this.rawClient.updateIpAllowlist(request).thenApply(response -> response.body());
    }

    /**
     * Update the IP allowlist configuration for the workspace.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Lockout Protection&quot; %}
     * The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
     * {% /admonition %}</p>
     */
    public CompletableFuture<IpAllowlist> updateIpAllowlist(IpAllowlist request, RequestOptions requestOptions) {
        return this.rawClient.updateIpAllowlist(request, requestOptions).thenApply(response -> response.body());
    }
}
