/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.items.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.NewsItemRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateNewsItemRequest.Builder.class)
public final class UpdateNewsItemRequest {
    private final int newsItemId;

    private final NewsItemRequest body;

    private final Map<String, Object> additionalProperties;

    private UpdateNewsItemRequest(int newsItemId, NewsItemRequest body, Map<String, Object> additionalProperties) {
        this.newsItemId = newsItemId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the news item which is given by Intercom.
     */
    @JsonProperty("news_item_id")
    public int getNewsItemId() {
        return newsItemId;
    }

    @JsonProperty("body")
    public NewsItemRequest getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateNewsItemRequest && equalTo((UpdateNewsItemRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateNewsItemRequest other) {
        return newsItemId == other.newsItemId && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.newsItemId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewsItemIdStage builder() {
        return new Builder();
    }

    public interface NewsItemIdStage {
        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         */
        BodyStage newsItemId(int newsItemId);

        Builder from(UpdateNewsItemRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull NewsItemRequest body);
    }

    public interface _FinalStage {
        UpdateNewsItemRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NewsItemIdStage, BodyStage, _FinalStage {
        private int newsItemId;

        private NewsItemRequest body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateNewsItemRequest other) {
            newsItemId(other.getNewsItemId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("news_item_id")
        public BodyStage newsItemId(int newsItemId) {
            this.newsItemId = newsItemId;
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull NewsItemRequest body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public UpdateNewsItemRequest build() {
            return new UpdateNewsItemRequest(newsItemId, body, additionalProperties);
        }
    }
}
