/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Tag.Builder.class)
public final class Tag {
    private final String id;

    private final String name;

    private final Optional<Integer> appliedAt;

    private final Optional<Reference> appliedBy;

    private final Map<String, Object> additionalProperties;

    private Tag(
            String id,
            String name,
            Optional<Integer> appliedAt,
            Optional<Reference> appliedBy,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.appliedAt = appliedAt;
        this.appliedBy = appliedBy;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return value is &quot;tag&quot;
     */
    @JsonProperty("type")
    public String getType() {
        return "tag";
    }

    /**
     * @return The id of the tag
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the tag
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The time when the tag was applied to the object
     */
    @JsonProperty("applied_at")
    public Optional<Integer> getAppliedAt() {
        return appliedAt;
    }

    @JsonProperty("applied_by")
    public Optional<Reference> getAppliedBy() {
        return appliedBy;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Tag && equalTo((Tag) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Tag other) {
        return id.equals(other.id)
                && name.equals(other.name)
                && appliedAt.equals(other.appliedAt)
                && appliedBy.equals(other.appliedBy);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.appliedAt, this.appliedBy);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The id of the tag</p>
         */
        NameStage id(@NotNull String id);

        Builder from(Tag other);
    }

    public interface NameStage {
        /**
         * <p>The name of the tag</p>
         */
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        Tag build();

        /**
         * <p>The time when the tag was applied to the object</p>
         */
        _FinalStage appliedAt(Optional<Integer> appliedAt);

        _FinalStage appliedAt(Integer appliedAt);

        _FinalStage appliedBy(Optional<Reference> appliedBy);

        _FinalStage appliedBy(Reference appliedBy);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, NameStage, _FinalStage {
        private String id;

        private String name;

        private Optional<Reference> appliedBy = Optional.empty();

        private Optional<Integer> appliedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Tag other) {
            id(other.getId());
            name(other.getName());
            appliedAt(other.getAppliedAt());
            appliedBy(other.getAppliedBy());
            return this;
        }

        /**
         * <p>The id of the tag</p>
         * <p>The id of the tag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The name of the tag</p>
         * <p>The name of the tag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage appliedBy(Reference appliedBy) {
            this.appliedBy = Optional.ofNullable(appliedBy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "applied_by", nulls = Nulls.SKIP)
        public _FinalStage appliedBy(Optional<Reference> appliedBy) {
            this.appliedBy = appliedBy;
            return this;
        }

        /**
         * <p>The time when the tag was applied to the object</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage appliedAt(Integer appliedAt) {
            this.appliedAt = Optional.ofNullable(appliedAt);
            return this;
        }

        /**
         * <p>The time when the tag was applied to the object</p>
         */
        @java.lang.Override
        @JsonSetter(value = "applied_at", nulls = Nulls.SKIP)
        public _FinalStage appliedAt(Optional<Integer> appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        @java.lang.Override
        public Tag build() {
            return new Tag(id, name, appliedAt, appliedBy, additionalProperties);
        }
    }
}
