/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.admins.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListActivityLogsRequest.Builder.class)
public final class ListActivityLogsRequest {
    private final String createdAtAfter;

    private final Optional<String> createdAtBefore;

    private final Map<String, Object> additionalProperties;

    private ListActivityLogsRequest(
            String createdAtAfter, Optional<String> createdAtBefore, Map<String, Object> additionalProperties) {
        this.createdAtAfter = createdAtAfter;
        this.createdAtBefore = createdAtBefore;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The start date that you request data for. It must be formatted as a UNIX timestamp.
     */
    @JsonProperty("created_at_after")
    public String getCreatedAtAfter() {
        return createdAtAfter;
    }

    /**
     * @return The end date that you request data for. It must be formatted as a UNIX timestamp.
     */
    @JsonProperty("created_at_before")
    public Optional<String> getCreatedAtBefore() {
        return createdAtBefore;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListActivityLogsRequest && equalTo((ListActivityLogsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListActivityLogsRequest other) {
        return createdAtAfter.equals(other.createdAtAfter) && createdAtBefore.equals(other.createdAtBefore);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.createdAtAfter, this.createdAtBefore);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtAfterStage builder() {
        return new Builder();
    }

    public interface CreatedAtAfterStage {
        /**
         * <p>The start date that you request data for. It must be formatted as a UNIX timestamp.</p>
         */
        _FinalStage createdAtAfter(@NotNull String createdAtAfter);

        Builder from(ListActivityLogsRequest other);
    }

    public interface _FinalStage {
        ListActivityLogsRequest build();

        /**
         * <p>The end date that you request data for. It must be formatted as a UNIX timestamp.</p>
         */
        _FinalStage createdAtBefore(Optional<String> createdAtBefore);

        _FinalStage createdAtBefore(String createdAtBefore);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CreatedAtAfterStage, _FinalStage {
        private String createdAtAfter;

        private Optional<String> createdAtBefore = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ListActivityLogsRequest other) {
            createdAtAfter(other.getCreatedAtAfter());
            createdAtBefore(other.getCreatedAtBefore());
            return this;
        }

        /**
         * <p>The start date that you request data for. It must be formatted as a UNIX timestamp.</p>
         * <p>The start date that you request data for. It must be formatted as a UNIX timestamp.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at_after")
        public _FinalStage createdAtAfter(@NotNull String createdAtAfter) {
            this.createdAtAfter = Objects.requireNonNull(createdAtAfter, "createdAtAfter must not be null");
            return this;
        }

        /**
         * <p>The end date that you request data for. It must be formatted as a UNIX timestamp.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage createdAtBefore(String createdAtBefore) {
            this.createdAtBefore = Optional.ofNullable(createdAtBefore);
            return this;
        }

        /**
         * <p>The end date that you request data for. It must be formatted as a UNIX timestamp.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "created_at_before", nulls = Nulls.SKIP)
        public _FinalStage createdAtBefore(Optional<String> createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
            return this;
        }

        @java.lang.Override
        public ListActivityLogsRequest build() {
            return new ListActivityLogsRequest(createdAtAfter, createdAtBefore, additionalProperties);
        }
    }
}
