/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.admins.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SetAwayAdminRequest.Builder.class)
public final class SetAwayAdminRequest {
    private final int id;

    private final boolean awayModeEnabled;

    private final boolean awayModeReassign;

    private final Optional<Integer> awayStatusReasonId;

    private final Map<String, Object> additionalProperties;

    private SetAwayAdminRequest(
            int id,
            boolean awayModeEnabled,
            boolean awayModeReassign,
            Optional<Integer> awayStatusReasonId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.awayStatusReasonId = awayStatusReasonId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given admin
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    /**
     * @return Set to &quot;true&quot; to change the status of the admin to away.
     */
    @JsonProperty("away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return awayModeEnabled;
    }

    /**
     * @return Set to &quot;true&quot; to assign any new conversation replies to your default inbox.
     */
    @JsonProperty("away_mode_reassign")
    public boolean getAwayModeReassign() {
        return awayModeReassign;
    }

    /**
     * @return The unique identifier of the away status reason
     */
    @JsonProperty("away_status_reason_id")
    public Optional<Integer> getAwayStatusReasonId() {
        return awayStatusReasonId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SetAwayAdminRequest && equalTo((SetAwayAdminRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SetAwayAdminRequest other) {
        return id == other.id
                && awayModeEnabled == other.awayModeEnabled
                && awayModeReassign == other.awayModeReassign
                && awayStatusReasonId.equals(other.awayStatusReasonId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.awayModeEnabled, this.awayModeReassign, this.awayStatusReasonId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier of a given admin</p>
         */
        AwayModeEnabledStage id(int id);

        Builder from(SetAwayAdminRequest other);
    }

    public interface AwayModeEnabledStage {
        /**
         * <p>Set to &quot;true&quot; to change the status of the admin to away.</p>
         */
        AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled);
    }

    public interface AwayModeReassignStage {
        /**
         * <p>Set to &quot;true&quot; to assign any new conversation replies to your default inbox.</p>
         */
        _FinalStage awayModeReassign(boolean awayModeReassign);
    }

    public interface _FinalStage {
        SetAwayAdminRequest build();

        /**
         * <p>The unique identifier of the away status reason</p>
         */
        _FinalStage awayStatusReasonId(Optional<Integer> awayStatusReasonId);

        _FinalStage awayStatusReasonId(Integer awayStatusReasonId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, AwayModeEnabledStage, AwayModeReassignStage, _FinalStage {
        private int id;

        private boolean awayModeEnabled;

        private boolean awayModeReassign;

        private Optional<Integer> awayStatusReasonId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SetAwayAdminRequest other) {
            id(other.getId());
            awayModeEnabled(other.getAwayModeEnabled());
            awayModeReassign(other.getAwayModeReassign());
            awayStatusReasonId(other.getAwayStatusReasonId());
            return this;
        }

        /**
         * <p>The unique identifier of a given admin</p>
         * <p>The unique identifier of a given admin</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public AwayModeEnabledStage id(int id) {
            this.id = id;
            return this;
        }

        /**
         * <p>Set to &quot;true&quot; to change the status of the admin to away.</p>
         * <p>Set to &quot;true&quot; to change the status of the admin to away.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        /**
         * <p>Set to &quot;true&quot; to assign any new conversation replies to your default inbox.</p>
         * <p>Set to &quot;true&quot; to assign any new conversation replies to your default inbox.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_reassign")
        public _FinalStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        /**
         * <p>The unique identifier of the away status reason</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage awayStatusReasonId(Integer awayStatusReasonId) {
            this.awayStatusReasonId = Optional.ofNullable(awayStatusReasonId);
            return this;
        }

        /**
         * <p>The unique identifier of the away status reason</p>
         */
        @java.lang.Override
        @JsonSetter(value = "away_status_reason_id", nulls = Nulls.SKIP)
        public _FinalStage awayStatusReasonId(Optional<Integer> awayStatusReasonId) {
            this.awayStatusReasonId = awayStatusReasonId;
            return this;
        }

        @java.lang.Override
        public SetAwayAdminRequest build() {
            return new SetAwayAdminRequest(
                    id, awayModeEnabled, awayModeReassign, awayStatusReasonId, additionalProperties);
        }
    }
}
