/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateContentImportSourceRequest.Builder.class)
public final class CreateContentImportSourceRequest {
    private final Optional<Status> status;

    private final String url;

    private final Map<String, Object> additionalProperties;

    private CreateContentImportSourceRequest(
            Optional<Status> status, String url, Map<String, Object> additionalProperties) {
        this.status = status;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return If you intend to create or update External Pages via the API, this should be set to <code>api</code>.
     */
    @JsonProperty("sync_behavior")
    public String getSyncBehavior() {
        return "api";
    }

    /**
     * @return The status of the content import source.
     */
    @JsonProperty("status")
    public Optional<Status> getStatus() {
        return status;
    }

    /**
     * @return The URL of the content import source.
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateContentImportSourceRequest && equalTo((CreateContentImportSourceRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateContentImportSourceRequest other) {
        return status.equals(other.status) && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.status, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    public interface UrlStage {
        /**
         * <p>The URL of the content import source.</p>
         */
        _FinalStage url(@NotNull String url);

        Builder from(CreateContentImportSourceRequest other);
    }

    public interface _FinalStage {
        CreateContentImportSourceRequest build();

        /**
         * <p>The status of the content import source.</p>
         */
        _FinalStage status(Optional<Status> status);

        _FinalStage status(Status status);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements UrlStage, _FinalStage {
        private String url;

        private Optional<Status> status = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateContentImportSourceRequest other) {
            status(other.getStatus());
            url(other.getUrl());
            return this;
        }

        /**
         * <p>The URL of the content import source.</p>
         * <p>The URL of the content import source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * <p>The status of the content import source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * <p>The status of the content import source.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public CreateContentImportSourceRequest build() {
            return new CreateContentImportSourceRequest(status, url, additionalProperties);
        }
    }

    public static final class Status {
        public static final Status DEACTIVATED = new Status(Value.DEACTIVATED, "deactivated");

        public static final Status ACTIVE = new Status(Value.ACTIVE, "active");

        private final Value value;

        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case DEACTIVATED:
                    return visitor.visitDeactivated();
                case ACTIVE:
                    return visitor.visitActive();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "deactivated":
                    return DEACTIVATED;
                case "active":
                    return ACTIVE;
                default:
                    return new Status(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ACTIVE,

            DEACTIVATED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitActive();

            T visitDeactivated();

            T visitUnknown(String unknownType);
        }
    }
}
