/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateExternalPageRequest.Builder.class)
public final class CreateExternalPageRequest {
    private final String title;

    private final String html;

    private final Optional<String> url;

    private final Optional<Boolean> aiAgentAvailability;

    private final Optional<Boolean> aiCopilotAvailability;

    private final int sourceId;

    private final String externalId;

    private final Map<String, Object> additionalProperties;

    private CreateExternalPageRequest(
            String title,
            String html,
            Optional<String> url,
            Optional<Boolean> aiAgentAvailability,
            Optional<Boolean> aiCopilotAvailability,
            int sourceId,
            String externalId,
            Map<String, Object> additionalProperties) {
        this.title = title;
        this.html = html;
        this.url = url;
        this.aiAgentAvailability = aiAgentAvailability;
        this.aiCopilotAvailability = aiCopilotAvailability;
        this.sourceId = sourceId;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The title of the external page.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The body of the external page in HTML.
     */
    @JsonProperty("html")
    public String getHtml() {
        return html;
    }

    /**
     * @return The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.
     */
    @JsonProperty("ai_agent_availability")
    public Optional<Boolean> getAiAgentAvailability() {
        return aiAgentAvailability;
    }

    /**
     * @return Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.
     */
    @JsonProperty("ai_copilot_availability")
    public Optional<Boolean> getAiCopilotAvailability() {
        return aiCopilotAvailability;
    }

    /**
     * @return Always en
     */
    @JsonProperty("locale")
    public String getLocale() {
        return "en";
    }

    /**
     * @return The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.
     */
    @JsonProperty("source_id")
    public int getSourceId() {
        return sourceId;
    }

    /**
     * @return The identifier for the external page which was given by the source. Must be unique for the source.
     */
    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateExternalPageRequest && equalTo((CreateExternalPageRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateExternalPageRequest other) {
        return title.equals(other.title)
                && html.equals(other.html)
                && url.equals(other.url)
                && aiAgentAvailability.equals(other.aiAgentAvailability)
                && aiCopilotAvailability.equals(other.aiCopilotAvailability)
                && sourceId == other.sourceId
                && externalId.equals(other.externalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.title,
                this.html,
                this.url,
                this.aiAgentAvailability,
                this.aiCopilotAvailability,
                this.sourceId,
                this.externalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    public interface TitleStage {
        /**
         * <p>The title of the external page.</p>
         */
        HtmlStage title(@NotNull String title);

        Builder from(CreateExternalPageRequest other);
    }

    public interface HtmlStage {
        /**
         * <p>The body of the external page in HTML.</p>
         */
        SourceIdStage html(@NotNull String html);
    }

    public interface SourceIdStage {
        /**
         * <p>The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.</p>
         */
        ExternalIdStage sourceId(int sourceId);
    }

    public interface ExternalIdStage {
        /**
         * <p>The identifier for the external page which was given by the source. Must be unique for the source.</p>
         */
        _FinalStage externalId(@NotNull String externalId);
    }

    public interface _FinalStage {
        CreateExternalPageRequest build();

        /**
         * <p>The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.</p>
         */
        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);

        /**
         * <p>Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.</p>
         */
        _FinalStage aiAgentAvailability(Optional<Boolean> aiAgentAvailability);

        _FinalStage aiAgentAvailability(Boolean aiAgentAvailability);

        /**
         * <p>Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.</p>
         */
        _FinalStage aiCopilotAvailability(Optional<Boolean> aiCopilotAvailability);

        _FinalStage aiCopilotAvailability(Boolean aiCopilotAvailability);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TitleStage, HtmlStage, SourceIdStage, ExternalIdStage, _FinalStage {
        private String title;

        private String html;

        private int sourceId;

        private String externalId;

        private Optional<Boolean> aiCopilotAvailability = Optional.empty();

        private Optional<Boolean> aiAgentAvailability = Optional.empty();

        private Optional<String> url = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateExternalPageRequest other) {
            title(other.getTitle());
            html(other.getHtml());
            url(other.getUrl());
            aiAgentAvailability(other.getAiAgentAvailability());
            aiCopilotAvailability(other.getAiCopilotAvailability());
            sourceId(other.getSourceId());
            externalId(other.getExternalId());
            return this;
        }

        /**
         * <p>The title of the external page.</p>
         * <p>The title of the external page.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public HtmlStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * <p>The body of the external page in HTML.</p>
         * <p>The body of the external page in HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("html")
        public SourceIdStage html(@NotNull String html) {
            this.html = Objects.requireNonNull(html, "html must not be null");
            return this;
        }

        /**
         * <p>The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.</p>
         * <p>The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("source_id")
        public ExternalIdStage sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        /**
         * <p>The identifier for the external page which was given by the source. Must be unique for the source.</p>
         * <p>The identifier for the external page which was given by the source. Must be unique for the source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        /**
         * <p>Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage aiCopilotAvailability(Boolean aiCopilotAvailability) {
            this.aiCopilotAvailability = Optional.ofNullable(aiCopilotAvailability);
            return this;
        }

        /**
         * <p>Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ai_copilot_availability", nulls = Nulls.SKIP)
        public _FinalStage aiCopilotAvailability(Optional<Boolean> aiCopilotAvailability) {
            this.aiCopilotAvailability = aiCopilotAvailability;
            return this;
        }

        /**
         * <p>Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage aiAgentAvailability(Boolean aiAgentAvailability) {
            this.aiAgentAvailability = Optional.ofNullable(aiAgentAvailability);
            return this;
        }

        /**
         * <p>Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ai_agent_availability", nulls = Nulls.SKIP)
        public _FinalStage aiAgentAvailability(Optional<Boolean> aiAgentAvailability) {
            this.aiAgentAvailability = aiAgentAvailability;
            return this;
        }

        /**
         * <p>The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @java.lang.Override
        public CreateExternalPageRequest build() {
            return new CreateExternalPageRequest(
                    title,
                    html,
                    url,
                    aiAgentAvailability,
                    aiCopilotAvailability,
                    sourceId,
                    externalId,
                    additionalProperties);
        }
    }
}
