/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.brands;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.brands.requests.RetrieveBrandRequest;
import com.intercom.api.resources.unstable.brands.types.Brand;
import com.intercom.api.resources.unstable.brands.types.BrandList;

public class BrandsClient {
    protected final ClientOptions clientOptions;

    private final RawBrandsClient rawClient;

    public BrandsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawBrandsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawBrandsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves all brands for the workspace, including the default brand.
     * The default brand id always matches the workspace
     */
    public BrandList listBrands() {
        return this.rawClient.listBrands().body();
    }

    /**
     * Retrieves all brands for the workspace, including the default brand.
     * The default brand id always matches the workspace
     */
    public BrandList listBrands(RequestOptions requestOptions) {
        return this.rawClient.listBrands(requestOptions).body();
    }

    /**
     * Fetches a specific brand by its unique identifier
     */
    public Brand retrieveBrand(RetrieveBrandRequest request) {
        return this.rawClient.retrieveBrand(request).body();
    }

    /**
     * Fetches a specific brand by its unique identifier
     */
    public Brand retrieveBrand(RetrieveBrandRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveBrand(request, requestOptions).body();
    }
}
