/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.conversations.types.ManageConversationRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ManageConversationRequest.Builder.class)
public final class ManageConversationRequest {
    private final String id;

    private final ManageConversationRequestBody body;

    private final Map<String, Object> additionalProperties;

    private ManageConversationRequest(
            String id, ManageConversationRequestBody body, Map<String, Object> additionalProperties) {
        this.id = id;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The identifier for the conversation as given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("body")
    public ManageConversationRequestBody getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ManageConversationRequest && equalTo((ManageConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ManageConversationRequest other) {
        return id.equals(other.id) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         */
        BodyStage id(@NotNull String id);

        Builder from(ManageConversationRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull ManageConversationRequestBody body);
    }

    public interface _FinalStage {
        ManageConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, BodyStage, _FinalStage {
        private String id;

        private ManageConversationRequestBody body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ManageConversationRequest other) {
            id(other.getId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         * <p>The identifier for the conversation as given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public BodyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull ManageConversationRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public ManageConversationRequest build() {
            return new ManageConversationRequest(id, body, additionalProperties);
        }
    }
}
