/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.emails;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.emails.requests.RetrieveEmailRequest;
import com.intercom.api.resources.unstable.emails.types.EmailList;
import com.intercom.api.resources.unstable.emails.types.EmailSetting;
import java.util.concurrent.CompletableFuture;

public class AsyncEmailsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawEmailsClient rawClient;

    public AsyncEmailsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEmailsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawEmailsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all sender email address settings for the workspace
     */
    public CompletableFuture<EmailList> listEmails() {
        return this.rawClient.listEmails().thenApply(response -> response.body());
    }

    /**
     * Lists all sender email address settings for the workspace
     */
    public CompletableFuture<EmailList> listEmails(RequestOptions requestOptions) {
        return this.rawClient.listEmails(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Fetches a specific email setting by its unique identifier
     */
    public CompletableFuture<EmailSetting> retrieveEmail(RetrieveEmailRequest request) {
        return this.rawClient.retrieveEmail(request).thenApply(response -> response.body());
    }

    /**
     * Fetches a specific email setting by its unique identifier
     */
    public CompletableFuture<EmailSetting> retrieveEmail(RetrieveEmailRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveEmail(request, requestOptions).thenApply(response -> response.body());
    }
}
