/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.macros.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = MacroList.Builder.class)
public final class MacroList {
    private final Optional<String> type;

    private final Optional<List<Optional<Macro>>> data;

    private final Optional<Pages> pages;

    private final Map<String, Object> additionalProperties;

    private MacroList(
            Optional<String> type,
            Optional<List<Optional<Macro>>> data,
            Optional<Pages> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.data = data;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always list
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The list of macro objects
     */
    @JsonProperty("data")
    public Optional<List<Optional<Macro>>> getData() {
        return data;
    }

    /**
     * @return Pagination information
     */
    @JsonProperty("pages")
    public Optional<Pages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof MacroList && equalTo((MacroList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MacroList other) {
        return type.equals(other.type) && data.equals(other.data) && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.data, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Optional<Macro>>> data = Optional.empty();

        private Optional<Pages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(MacroList other) {
            type(other.getType());
            data(other.getData());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>Always list</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The list of macro objects</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<Optional<Macro>>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<Optional<Macro>> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        /**
         * <p>Pagination information</p>
         */
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<Pages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Pages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public MacroList build() {
            return new MacroList(type, data, pages, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Pages.Builder.class)
    public static final class Pages {
        private final Optional<String> type;

        private final Optional<Integer> perPage;

        private final Optional<Next> next;

        private final Map<String, Object> additionalProperties;

        private Pages(
                Optional<String> type,
                Optional<Integer> perPage,
                Optional<Next> next,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.perPage = perPage;
            this.next = next;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of pagination
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return Number of results per page
         */
        @JsonProperty("per_page")
        public Optional<Integer> getPerPage() {
            return perPage;
        }

        /**
         * @return Cursor for the next page
         */
        @JsonProperty("next")
        public Optional<Next> getNext() {
            return next;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Pages && equalTo((Pages) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Pages other) {
            return type.equals(other.type) && perPage.equals(other.perPage) && next.equals(other.next);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.perPage, this.next);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<Integer> perPage = Optional.empty();

            private Optional<Next> next = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Pages other) {
                type(other.getType());
                perPage(other.getPerPage());
                next(other.getNext());
                return this;
            }

            /**
             * <p>The type of pagination</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>Number of results per page</p>
             */
            @JsonSetter(value = "per_page", nulls = Nulls.SKIP)
            public Builder perPage(Optional<Integer> perPage) {
                this.perPage = perPage;
                return this;
            }

            public Builder perPage(Integer perPage) {
                this.perPage = Optional.ofNullable(perPage);
                return this;
            }

            /**
             * <p>Cursor for the next page</p>
             */
            @JsonSetter(value = "next", nulls = Nulls.SKIP)
            public Builder next(Optional<Next> next) {
                this.next = next;
                return this;
            }

            public Builder next(Next next) {
                this.next = Optional.ofNullable(next);
                return this;
            }

            public Pages build() {
                return new Pages(type, perPage, next, additionalProperties);
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = Next.Builder.class)
        public static final class Next {
            private final Optional<String> startingAfter;

            private final Map<String, Object> additionalProperties;

            private Next(Optional<String> startingAfter, Map<String, Object> additionalProperties) {
                this.startingAfter = startingAfter;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return Base64-encoded cursor containing [updated_at, id] for pagination
             */
            @JsonProperty("starting_after")
            public Optional<String> getStartingAfter() {
                return startingAfter;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof Next && equalTo((Next) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Next other) {
                return startingAfter.equals(other.startingAfter);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.startingAfter);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder {
                private Optional<String> startingAfter = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                public Builder from(Next other) {
                    startingAfter(other.getStartingAfter());
                    return this;
                }

                /**
                 * <p>Base64-encoded cursor containing [updated_at, id] for pagination</p>
                 */
                @JsonSetter(value = "starting_after", nulls = Nulls.SKIP)
                public Builder startingAfter(Optional<String> startingAfter) {
                    this.startingAfter = startingAfter;
                    return this;
                }

                public Builder startingAfter(String startingAfter) {
                    this.startingAfter = Optional.ofNullable(startingAfter);
                    return this;
                }

                public Next build() {
                    return new Next(startingAfter, additionalProperties);
                }
            }
        }
    }
}
