/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.segments;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.segments.requests.ListSegmentsRequest;
import com.intercom.api.resources.unstable.segments.requests.RetrieveSegmentRequest;
import com.intercom.api.resources.unstable.segments.types.Segment;
import com.intercom.api.resources.unstable.types.SegmentList;

public class SegmentsClient {
    protected final ClientOptions clientOptions;

    private final RawSegmentsClient rawClient;

    public SegmentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSegmentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawSegmentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all segments.
     */
    public SegmentList listSegments() {
        return this.rawClient.listSegments().body();
    }

    /**
     * You can fetch a list of all segments.
     */
    public SegmentList listSegments(ListSegmentsRequest request) {
        return this.rawClient.listSegments(request).body();
    }

    /**
     * You can fetch a list of all segments.
     */
    public SegmentList listSegments(ListSegmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listSegments(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single segment.
     */
    public Segment retrieveSegment(RetrieveSegmentRequest request) {
        return this.rawClient.retrieveSegment(request).body();
    }

    /**
     * You can fetch the details of a single segment.
     */
    public Segment retrieveSegment(RetrieveSegmentRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveSegment(request, requestOptions).body();
    }
}
