/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.subscriptiontypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.AttachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.DetachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;

public class SubscriptionTypesClient {
    protected final ClientOptions clientOptions;

    private final RawSubscriptionTypesClient rawClient;

    public SubscriptionTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSubscriptionTypesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawSubscriptionTypesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
     * <p>1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.</p>
     * <p>2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.</p>
     * <p>This will return a subscription type model for the subscription type that was added to the contact.</p>
     */
    public SubscriptionType attachSubscriptionTypeToContact(AttachSubscriptionTypeToContactRequest request) {
        return this.rawClient.attachSubscriptionTypeToContact(request).body();
    }

    /**
     * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
     * <p>1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.</p>
     * <p>2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.</p>
     * <p>This will return a subscription type model for the subscription type that was added to the contact.</p>
     */
    public SubscriptionType attachSubscriptionTypeToContact(
            AttachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .attachSubscriptionTypeToContact(request, requestOptions)
                .body();
    }

    /**
     * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
     */
    public SubscriptionType detachSubscriptionTypeToContact(DetachSubscriptionTypeToContactRequest request) {
        return this.rawClient.detachSubscriptionTypeToContact(request).body();
    }

    /**
     * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
     */
    public SubscriptionType detachSubscriptionTypeToContact(
            DetachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .detachSubscriptionTypeToContact(request, requestOptions)
                .body();
    }

    /**
     * You can list all subscription types. A list of subscription type objects will be returned.
     */
    public SubscriptionTypeList listSubscriptionTypes() {
        return this.rawClient.listSubscriptionTypes().body();
    }

    /**
     * You can list all subscription types. A list of subscription type objects will be returned.
     */
    public SubscriptionTypeList listSubscriptionTypes(RequestOptions requestOptions) {
        return this.rawClient.listSubscriptionTypes(requestOptions).body();
    }
}
