/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.teams;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.teams.requests.RetrieveTeamRequest;
import com.intercom.api.resources.unstable.teams.types.Team;
import com.intercom.api.resources.unstable.types.TeamList;
import java.util.concurrent.CompletableFuture;

public class AsyncTeamsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTeamsClient rawClient;

    public AsyncTeamsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTeamsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTeamsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * This will return a list of team objects for the App.
     */
    public CompletableFuture<TeamList> listTeams() {
        return this.rawClient.listTeams().thenApply(response -> response.body());
    }

    /**
     * This will return a list of team objects for the App.
     */
    public CompletableFuture<TeamList> listTeams(RequestOptions requestOptions) {
        return this.rawClient.listTeams(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public CompletableFuture<Team> retrieveTeam(RetrieveTeamRequest request) {
        return this.rawClient.retrieveTeam(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public CompletableFuture<Team> retrieveTeam(RetrieveTeamRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveTeam(request, requestOptions).thenApply(response -> response.body());
    }
}
