/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.teams.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.AdminPriorityLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Team.Builder.class)
public final class Team {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<List<Integer>> adminIds;

    private final Optional<AdminPriorityLevel> adminPriorityLevel;

    private final Map<String, Object> additionalProperties;

    private Team(
            Optional<String> type,
            Optional<String> id,
            Optional<String> name,
            Optional<List<Integer>> adminIds,
            Optional<AdminPriorityLevel> adminPriorityLevel,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.adminIds = adminIds;
        this.adminPriorityLevel = adminPriorityLevel;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is always &quot;team&quot;
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id of the team
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The name of the team
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The list of admin IDs that are a part of the team.
     */
    @JsonProperty("admin_ids")
    public Optional<List<Integer>> getAdminIds() {
        return adminIds;
    }

    @JsonProperty("admin_priority_level")
    public Optional<AdminPriorityLevel> getAdminPriorityLevel() {
        return adminPriorityLevel;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Team && equalTo((Team) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Team other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && adminIds.equals(other.adminIds)
                && adminPriorityLevel.equals(other.adminPriorityLevel);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.adminIds, this.adminPriorityLevel);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<List<Integer>> adminIds = Optional.empty();

        private Optional<AdminPriorityLevel> adminPriorityLevel = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Team other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            adminIds(other.getAdminIds());
            adminPriorityLevel(other.getAdminPriorityLevel());
            return this;
        }

        /**
         * <p>Value is always &quot;team&quot;</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id of the team</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The name of the team</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The list of admin IDs that are a part of the team.</p>
         */
        @JsonSetter(value = "admin_ids", nulls = Nulls.SKIP)
        public Builder adminIds(Optional<List<Integer>> adminIds) {
            this.adminIds = adminIds;
            return this;
        }

        public Builder adminIds(List<Integer> adminIds) {
            this.adminIds = Optional.ofNullable(adminIds);
            return this;
        }

        @JsonSetter(value = "admin_priority_level", nulls = Nulls.SKIP)
        public Builder adminPriorityLevel(Optional<AdminPriorityLevel> adminPriorityLevel) {
            this.adminPriorityLevel = adminPriorityLevel;
            return this;
        }

        public Builder adminPriorityLevel(AdminPriorityLevel adminPriorityLevel) {
            this.adminPriorityLevel = Optional.ofNullable(adminPriorityLevel);
            return this;
        }

        public Team build() {
            return new Team(type, id, name, adminIds, adminPriorityLevel, additionalProperties);
        }
    }
}
