/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationStatistics.Builder.class)
public final class ConversationStatistics {
    private final Optional<String> type;

    private final Optional<Integer> timeToAssignment;

    private final Optional<Integer> timeToAdminReply;

    private final Optional<Integer> timeToFirstClose;

    private final Optional<Integer> timeToLastClose;

    private final Optional<Integer> medianTimeToReply;

    private final Optional<Integer> firstContactReplyAt;

    private final Optional<Integer> firstAssignmentAt;

    private final Optional<Integer> firstAdminReplyAt;

    private final Optional<Integer> firstCloseAt;

    private final Optional<Integer> lastAssignmentAt;

    private final Optional<Integer> lastAssignmentAdminReplyAt;

    private final Optional<Integer> lastContactReplyAt;

    private final Optional<Integer> lastAdminReplyAt;

    private final Optional<Integer> lastCloseAt;

    private final Optional<String> lastClosedById;

    private final Optional<Integer> countReopens;

    private final Optional<Integer> countAssignments;

    private final Optional<Integer> countConversationParts;

    private final Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam;

    private final Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours;

    private final Optional<Integer> handlingTime;

    private final Optional<Integer> adjustedHandlingTime;

    private final Map<String, Object> additionalProperties;

    private ConversationStatistics(
            Optional<String> type,
            Optional<Integer> timeToAssignment,
            Optional<Integer> timeToAdminReply,
            Optional<Integer> timeToFirstClose,
            Optional<Integer> timeToLastClose,
            Optional<Integer> medianTimeToReply,
            Optional<Integer> firstContactReplyAt,
            Optional<Integer> firstAssignmentAt,
            Optional<Integer> firstAdminReplyAt,
            Optional<Integer> firstCloseAt,
            Optional<Integer> lastAssignmentAt,
            Optional<Integer> lastAssignmentAdminReplyAt,
            Optional<Integer> lastContactReplyAt,
            Optional<Integer> lastAdminReplyAt,
            Optional<Integer> lastCloseAt,
            Optional<String> lastClosedById,
            Optional<Integer> countReopens,
            Optional<Integer> countAssignments,
            Optional<Integer> countConversationParts,
            Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam,
            Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours,
            Optional<Integer> handlingTime,
            Optional<Integer> adjustedHandlingTime,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.timeToAssignment = timeToAssignment;
        this.timeToAdminReply = timeToAdminReply;
        this.timeToFirstClose = timeToFirstClose;
        this.timeToLastClose = timeToLastClose;
        this.medianTimeToReply = medianTimeToReply;
        this.firstContactReplyAt = firstContactReplyAt;
        this.firstAssignmentAt = firstAssignmentAt;
        this.firstAdminReplyAt = firstAdminReplyAt;
        this.firstCloseAt = firstCloseAt;
        this.lastAssignmentAt = lastAssignmentAt;
        this.lastAssignmentAdminReplyAt = lastAssignmentAdminReplyAt;
        this.lastContactReplyAt = lastContactReplyAt;
        this.lastAdminReplyAt = lastAdminReplyAt;
        this.lastCloseAt = lastCloseAt;
        this.lastClosedById = lastClosedById;
        this.countReopens = countReopens;
        this.countAssignments = countAssignments;
        this.countConversationParts = countConversationParts;
        this.assignedTeamFirstResponseTimeByTeam = assignedTeamFirstResponseTimeByTeam;
        this.assignedTeamFirstResponseTimeInOfficeHours = assignedTeamFirstResponseTimeInOfficeHours;
        this.handlingTime = handlingTime;
        this.adjustedHandlingTime = adjustedHandlingTime;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return Duration until last assignment before first admin reply. In seconds.
     */
    @JsonProperty("time_to_assignment")
    public Optional<Integer> getTimeToAssignment() {
        return timeToAssignment;
    }

    /**
     * @return Duration until first admin reply. Subtracts out of business hours. In seconds.
     */
    @JsonProperty("time_to_admin_reply")
    public Optional<Integer> getTimeToAdminReply() {
        return timeToAdminReply;
    }

    /**
     * @return Duration until conversation was closed first time. Subtracts out of business hours. In seconds.
     */
    @JsonProperty("time_to_first_close")
    public Optional<Integer> getTimeToFirstClose() {
        return timeToFirstClose;
    }

    /**
     * @return Duration until conversation was closed last time. Subtracts out of business hours. In seconds.
     */
    @JsonProperty("time_to_last_close")
    public Optional<Integer> getTimeToLastClose() {
        return timeToLastClose;
    }

    /**
     * @return Median based on all admin replies after a contact reply. Subtracts out of business hours. In seconds.
     */
    @JsonProperty("median_time_to_reply")
    public Optional<Integer> getMedianTimeToReply() {
        return medianTimeToReply;
    }

    /**
     * @return Time of first text conversation part from a contact.
     */
    @JsonProperty("first_contact_reply_at")
    public Optional<Integer> getFirstContactReplyAt() {
        return firstContactReplyAt;
    }

    /**
     * @return Time of first assignment after first_contact_reply_at.
     */
    @JsonProperty("first_assignment_at")
    public Optional<Integer> getFirstAssignmentAt() {
        return firstAssignmentAt;
    }

    /**
     * @return Time of first admin reply after first_contact_reply_at.
     */
    @JsonProperty("first_admin_reply_at")
    public Optional<Integer> getFirstAdminReplyAt() {
        return firstAdminReplyAt;
    }

    /**
     * @return Time of first close after first_contact_reply_at.
     */
    @JsonProperty("first_close_at")
    public Optional<Integer> getFirstCloseAt() {
        return firstCloseAt;
    }

    /**
     * @return Time of last assignment after first_contact_reply_at.
     */
    @JsonProperty("last_assignment_at")
    public Optional<Integer> getLastAssignmentAt() {
        return lastAssignmentAt;
    }

    /**
     * @return Time of first admin reply since most recent assignment.
     */
    @JsonProperty("last_assignment_admin_reply_at")
    public Optional<Integer> getLastAssignmentAdminReplyAt() {
        return lastAssignmentAdminReplyAt;
    }

    /**
     * @return Time of the last conversation part from a contact.
     */
    @JsonProperty("last_contact_reply_at")
    public Optional<Integer> getLastContactReplyAt() {
        return lastContactReplyAt;
    }

    /**
     * @return Time of the last conversation part from an admin.
     */
    @JsonProperty("last_admin_reply_at")
    public Optional<Integer> getLastAdminReplyAt() {
        return lastAdminReplyAt;
    }

    /**
     * @return Time of the last conversation close.
     */
    @JsonProperty("last_close_at")
    public Optional<Integer> getLastCloseAt() {
        return lastCloseAt;
    }

    /**
     * @return The last admin who closed the conversation. Returns a reference to an Admin object.
     */
    @JsonProperty("last_closed_by_id")
    public Optional<String> getLastClosedById() {
        return lastClosedById;
    }

    /**
     * @return Number of reopens after first_contact_reply_at.
     */
    @JsonProperty("count_reopens")
    public Optional<Integer> getCountReopens() {
        return countReopens;
    }

    /**
     * @return Number of assignments after first_contact_reply_at.
     */
    @JsonProperty("count_assignments")
    public Optional<Integer> getCountAssignments() {
        return countAssignments;
    }

    /**
     * @return Total number of conversation parts.
     */
    @JsonProperty("count_conversation_parts")
    public Optional<Integer> getCountConversationParts() {
        return countConversationParts;
    }

    /**
     * @return An array of conversation response time objects
     */
    @JsonProperty("assigned_team_first_response_time_by_team")
    public Optional<List<ConversationResponseTime>> getAssignedTeamFirstResponseTimeByTeam() {
        return assignedTeamFirstResponseTimeByTeam;
    }

    /**
     * @return An array of conversation response time objects within office hours
     */
    @JsonProperty("assigned_team_first_response_time_in_office_hours")
    public Optional<List<ConversationResponseTime>> getAssignedTeamFirstResponseTimeInOfficeHours() {
        return assignedTeamFirstResponseTimeInOfficeHours;
    }

    /**
     * @return Time from conversation assignment to conversation close in seconds.
     */
    @JsonProperty("handling_time")
    public Optional<Integer> getHandlingTime() {
        return handlingTime;
    }

    /**
     * @return Adjusted handling time for conversation in seconds. This is the active handling time excluding idle periods when teammates are not actively working on the conversation.
     */
    @JsonProperty("adjusted_handling_time")
    public Optional<Integer> getAdjustedHandlingTime() {
        return adjustedHandlingTime;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationStatistics && equalTo((ConversationStatistics) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationStatistics other) {
        return type.equals(other.type)
                && timeToAssignment.equals(other.timeToAssignment)
                && timeToAdminReply.equals(other.timeToAdminReply)
                && timeToFirstClose.equals(other.timeToFirstClose)
                && timeToLastClose.equals(other.timeToLastClose)
                && medianTimeToReply.equals(other.medianTimeToReply)
                && firstContactReplyAt.equals(other.firstContactReplyAt)
                && firstAssignmentAt.equals(other.firstAssignmentAt)
                && firstAdminReplyAt.equals(other.firstAdminReplyAt)
                && firstCloseAt.equals(other.firstCloseAt)
                && lastAssignmentAt.equals(other.lastAssignmentAt)
                && lastAssignmentAdminReplyAt.equals(other.lastAssignmentAdminReplyAt)
                && lastContactReplyAt.equals(other.lastContactReplyAt)
                && lastAdminReplyAt.equals(other.lastAdminReplyAt)
                && lastCloseAt.equals(other.lastCloseAt)
                && lastClosedById.equals(other.lastClosedById)
                && countReopens.equals(other.countReopens)
                && countAssignments.equals(other.countAssignments)
                && countConversationParts.equals(other.countConversationParts)
                && assignedTeamFirstResponseTimeByTeam.equals(other.assignedTeamFirstResponseTimeByTeam)
                && assignedTeamFirstResponseTimeInOfficeHours.equals(other.assignedTeamFirstResponseTimeInOfficeHours)
                && handlingTime.equals(other.handlingTime)
                && adjustedHandlingTime.equals(other.adjustedHandlingTime);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.timeToAssignment,
                this.timeToAdminReply,
                this.timeToFirstClose,
                this.timeToLastClose,
                this.medianTimeToReply,
                this.firstContactReplyAt,
                this.firstAssignmentAt,
                this.firstAdminReplyAt,
                this.firstCloseAt,
                this.lastAssignmentAt,
                this.lastAssignmentAdminReplyAt,
                this.lastContactReplyAt,
                this.lastAdminReplyAt,
                this.lastCloseAt,
                this.lastClosedById,
                this.countReopens,
                this.countAssignments,
                this.countConversationParts,
                this.assignedTeamFirstResponseTimeByTeam,
                this.assignedTeamFirstResponseTimeInOfficeHours,
                this.handlingTime,
                this.adjustedHandlingTime);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Integer> timeToAssignment = Optional.empty();

        private Optional<Integer> timeToAdminReply = Optional.empty();

        private Optional<Integer> timeToFirstClose = Optional.empty();

        private Optional<Integer> timeToLastClose = Optional.empty();

        private Optional<Integer> medianTimeToReply = Optional.empty();

        private Optional<Integer> firstContactReplyAt = Optional.empty();

        private Optional<Integer> firstAssignmentAt = Optional.empty();

        private Optional<Integer> firstAdminReplyAt = Optional.empty();

        private Optional<Integer> firstCloseAt = Optional.empty();

        private Optional<Integer> lastAssignmentAt = Optional.empty();

        private Optional<Integer> lastAssignmentAdminReplyAt = Optional.empty();

        private Optional<Integer> lastContactReplyAt = Optional.empty();

        private Optional<Integer> lastAdminReplyAt = Optional.empty();

        private Optional<Integer> lastCloseAt = Optional.empty();

        private Optional<String> lastClosedById = Optional.empty();

        private Optional<Integer> countReopens = Optional.empty();

        private Optional<Integer> countAssignments = Optional.empty();

        private Optional<Integer> countConversationParts = Optional.empty();

        private Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam = Optional.empty();

        private Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours = Optional.empty();

        private Optional<Integer> handlingTime = Optional.empty();

        private Optional<Integer> adjustedHandlingTime = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationStatistics other) {
            type(other.getType());
            timeToAssignment(other.getTimeToAssignment());
            timeToAdminReply(other.getTimeToAdminReply());
            timeToFirstClose(other.getTimeToFirstClose());
            timeToLastClose(other.getTimeToLastClose());
            medianTimeToReply(other.getMedianTimeToReply());
            firstContactReplyAt(other.getFirstContactReplyAt());
            firstAssignmentAt(other.getFirstAssignmentAt());
            firstAdminReplyAt(other.getFirstAdminReplyAt());
            firstCloseAt(other.getFirstCloseAt());
            lastAssignmentAt(other.getLastAssignmentAt());
            lastAssignmentAdminReplyAt(other.getLastAssignmentAdminReplyAt());
            lastContactReplyAt(other.getLastContactReplyAt());
            lastAdminReplyAt(other.getLastAdminReplyAt());
            lastCloseAt(other.getLastCloseAt());
            lastClosedById(other.getLastClosedById());
            countReopens(other.getCountReopens());
            countAssignments(other.getCountAssignments());
            countConversationParts(other.getCountConversationParts());
            assignedTeamFirstResponseTimeByTeam(other.getAssignedTeamFirstResponseTimeByTeam());
            assignedTeamFirstResponseTimeInOfficeHours(other.getAssignedTeamFirstResponseTimeInOfficeHours());
            handlingTime(other.getHandlingTime());
            adjustedHandlingTime(other.getAdjustedHandlingTime());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Duration until last assignment before first admin reply. In seconds.</p>
         */
        @JsonSetter(value = "time_to_assignment", nulls = Nulls.SKIP)
        public Builder timeToAssignment(Optional<Integer> timeToAssignment) {
            this.timeToAssignment = timeToAssignment;
            return this;
        }

        public Builder timeToAssignment(Integer timeToAssignment) {
            this.timeToAssignment = Optional.ofNullable(timeToAssignment);
            return this;
        }

        /**
         * <p>Duration until first admin reply. Subtracts out of business hours. In seconds.</p>
         */
        @JsonSetter(value = "time_to_admin_reply", nulls = Nulls.SKIP)
        public Builder timeToAdminReply(Optional<Integer> timeToAdminReply) {
            this.timeToAdminReply = timeToAdminReply;
            return this;
        }

        public Builder timeToAdminReply(Integer timeToAdminReply) {
            this.timeToAdminReply = Optional.ofNullable(timeToAdminReply);
            return this;
        }

        /**
         * <p>Duration until conversation was closed first time. Subtracts out of business hours. In seconds.</p>
         */
        @JsonSetter(value = "time_to_first_close", nulls = Nulls.SKIP)
        public Builder timeToFirstClose(Optional<Integer> timeToFirstClose) {
            this.timeToFirstClose = timeToFirstClose;
            return this;
        }

        public Builder timeToFirstClose(Integer timeToFirstClose) {
            this.timeToFirstClose = Optional.ofNullable(timeToFirstClose);
            return this;
        }

        /**
         * <p>Duration until conversation was closed last time. Subtracts out of business hours. In seconds.</p>
         */
        @JsonSetter(value = "time_to_last_close", nulls = Nulls.SKIP)
        public Builder timeToLastClose(Optional<Integer> timeToLastClose) {
            this.timeToLastClose = timeToLastClose;
            return this;
        }

        public Builder timeToLastClose(Integer timeToLastClose) {
            this.timeToLastClose = Optional.ofNullable(timeToLastClose);
            return this;
        }

        /**
         * <p>Median based on all admin replies after a contact reply. Subtracts out of business hours. In seconds.</p>
         */
        @JsonSetter(value = "median_time_to_reply", nulls = Nulls.SKIP)
        public Builder medianTimeToReply(Optional<Integer> medianTimeToReply) {
            this.medianTimeToReply = medianTimeToReply;
            return this;
        }

        public Builder medianTimeToReply(Integer medianTimeToReply) {
            this.medianTimeToReply = Optional.ofNullable(medianTimeToReply);
            return this;
        }

        /**
         * <p>Time of first text conversation part from a contact.</p>
         */
        @JsonSetter(value = "first_contact_reply_at", nulls = Nulls.SKIP)
        public Builder firstContactReplyAt(Optional<Integer> firstContactReplyAt) {
            this.firstContactReplyAt = firstContactReplyAt;
            return this;
        }

        public Builder firstContactReplyAt(Integer firstContactReplyAt) {
            this.firstContactReplyAt = Optional.ofNullable(firstContactReplyAt);
            return this;
        }

        /**
         * <p>Time of first assignment after first_contact_reply_at.</p>
         */
        @JsonSetter(value = "first_assignment_at", nulls = Nulls.SKIP)
        public Builder firstAssignmentAt(Optional<Integer> firstAssignmentAt) {
            this.firstAssignmentAt = firstAssignmentAt;
            return this;
        }

        public Builder firstAssignmentAt(Integer firstAssignmentAt) {
            this.firstAssignmentAt = Optional.ofNullable(firstAssignmentAt);
            return this;
        }

        /**
         * <p>Time of first admin reply after first_contact_reply_at.</p>
         */
        @JsonSetter(value = "first_admin_reply_at", nulls = Nulls.SKIP)
        public Builder firstAdminReplyAt(Optional<Integer> firstAdminReplyAt) {
            this.firstAdminReplyAt = firstAdminReplyAt;
            return this;
        }

        public Builder firstAdminReplyAt(Integer firstAdminReplyAt) {
            this.firstAdminReplyAt = Optional.ofNullable(firstAdminReplyAt);
            return this;
        }

        /**
         * <p>Time of first close after first_contact_reply_at.</p>
         */
        @JsonSetter(value = "first_close_at", nulls = Nulls.SKIP)
        public Builder firstCloseAt(Optional<Integer> firstCloseAt) {
            this.firstCloseAt = firstCloseAt;
            return this;
        }

        public Builder firstCloseAt(Integer firstCloseAt) {
            this.firstCloseAt = Optional.ofNullable(firstCloseAt);
            return this;
        }

        /**
         * <p>Time of last assignment after first_contact_reply_at.</p>
         */
        @JsonSetter(value = "last_assignment_at", nulls = Nulls.SKIP)
        public Builder lastAssignmentAt(Optional<Integer> lastAssignmentAt) {
            this.lastAssignmentAt = lastAssignmentAt;
            return this;
        }

        public Builder lastAssignmentAt(Integer lastAssignmentAt) {
            this.lastAssignmentAt = Optional.ofNullable(lastAssignmentAt);
            return this;
        }

        /**
         * <p>Time of first admin reply since most recent assignment.</p>
         */
        @JsonSetter(value = "last_assignment_admin_reply_at", nulls = Nulls.SKIP)
        public Builder lastAssignmentAdminReplyAt(Optional<Integer> lastAssignmentAdminReplyAt) {
            this.lastAssignmentAdminReplyAt = lastAssignmentAdminReplyAt;
            return this;
        }

        public Builder lastAssignmentAdminReplyAt(Integer lastAssignmentAdminReplyAt) {
            this.lastAssignmentAdminReplyAt = Optional.ofNullable(lastAssignmentAdminReplyAt);
            return this;
        }

        /**
         * <p>Time of the last conversation part from a contact.</p>
         */
        @JsonSetter(value = "last_contact_reply_at", nulls = Nulls.SKIP)
        public Builder lastContactReplyAt(Optional<Integer> lastContactReplyAt) {
            this.lastContactReplyAt = lastContactReplyAt;
            return this;
        }

        public Builder lastContactReplyAt(Integer lastContactReplyAt) {
            this.lastContactReplyAt = Optional.ofNullable(lastContactReplyAt);
            return this;
        }

        /**
         * <p>Time of the last conversation part from an admin.</p>
         */
        @JsonSetter(value = "last_admin_reply_at", nulls = Nulls.SKIP)
        public Builder lastAdminReplyAt(Optional<Integer> lastAdminReplyAt) {
            this.lastAdminReplyAt = lastAdminReplyAt;
            return this;
        }

        public Builder lastAdminReplyAt(Integer lastAdminReplyAt) {
            this.lastAdminReplyAt = Optional.ofNullable(lastAdminReplyAt);
            return this;
        }

        /**
         * <p>Time of the last conversation close.</p>
         */
        @JsonSetter(value = "last_close_at", nulls = Nulls.SKIP)
        public Builder lastCloseAt(Optional<Integer> lastCloseAt) {
            this.lastCloseAt = lastCloseAt;
            return this;
        }

        public Builder lastCloseAt(Integer lastCloseAt) {
            this.lastCloseAt = Optional.ofNullable(lastCloseAt);
            return this;
        }

        /**
         * <p>The last admin who closed the conversation. Returns a reference to an Admin object.</p>
         */
        @JsonSetter(value = "last_closed_by_id", nulls = Nulls.SKIP)
        public Builder lastClosedById(Optional<String> lastClosedById) {
            this.lastClosedById = lastClosedById;
            return this;
        }

        public Builder lastClosedById(String lastClosedById) {
            this.lastClosedById = Optional.ofNullable(lastClosedById);
            return this;
        }

        /**
         * <p>Number of reopens after first_contact_reply_at.</p>
         */
        @JsonSetter(value = "count_reopens", nulls = Nulls.SKIP)
        public Builder countReopens(Optional<Integer> countReopens) {
            this.countReopens = countReopens;
            return this;
        }

        public Builder countReopens(Integer countReopens) {
            this.countReopens = Optional.ofNullable(countReopens);
            return this;
        }

        /**
         * <p>Number of assignments after first_contact_reply_at.</p>
         */
        @JsonSetter(value = "count_assignments", nulls = Nulls.SKIP)
        public Builder countAssignments(Optional<Integer> countAssignments) {
            this.countAssignments = countAssignments;
            return this;
        }

        public Builder countAssignments(Integer countAssignments) {
            this.countAssignments = Optional.ofNullable(countAssignments);
            return this;
        }

        /**
         * <p>Total number of conversation parts.</p>
         */
        @JsonSetter(value = "count_conversation_parts", nulls = Nulls.SKIP)
        public Builder countConversationParts(Optional<Integer> countConversationParts) {
            this.countConversationParts = countConversationParts;
            return this;
        }

        public Builder countConversationParts(Integer countConversationParts) {
            this.countConversationParts = Optional.ofNullable(countConversationParts);
            return this;
        }

        /**
         * <p>An array of conversation response time objects</p>
         */
        @JsonSetter(value = "assigned_team_first_response_time_by_team", nulls = Nulls.SKIP)
        public Builder assignedTeamFirstResponseTimeByTeam(
                Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam) {
            this.assignedTeamFirstResponseTimeByTeam = assignedTeamFirstResponseTimeByTeam;
            return this;
        }

        public Builder assignedTeamFirstResponseTimeByTeam(
                List<ConversationResponseTime> assignedTeamFirstResponseTimeByTeam) {
            this.assignedTeamFirstResponseTimeByTeam = Optional.ofNullable(assignedTeamFirstResponseTimeByTeam);
            return this;
        }

        /**
         * <p>An array of conversation response time objects within office hours</p>
         */
        @JsonSetter(value = "assigned_team_first_response_time_in_office_hours", nulls = Nulls.SKIP)
        public Builder assignedTeamFirstResponseTimeInOfficeHours(
                Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours) {
            this.assignedTeamFirstResponseTimeInOfficeHours = assignedTeamFirstResponseTimeInOfficeHours;
            return this;
        }

        public Builder assignedTeamFirstResponseTimeInOfficeHours(
                List<ConversationResponseTime> assignedTeamFirstResponseTimeInOfficeHours) {
            this.assignedTeamFirstResponseTimeInOfficeHours =
                    Optional.ofNullable(assignedTeamFirstResponseTimeInOfficeHours);
            return this;
        }

        /**
         * <p>Time from conversation assignment to conversation close in seconds.</p>
         */
        @JsonSetter(value = "handling_time", nulls = Nulls.SKIP)
        public Builder handlingTime(Optional<Integer> handlingTime) {
            this.handlingTime = handlingTime;
            return this;
        }

        public Builder handlingTime(Integer handlingTime) {
            this.handlingTime = Optional.ofNullable(handlingTime);
            return this;
        }

        /**
         * <p>Adjusted handling time for conversation in seconds. This is the active handling time excluding idle periods when teammates are not actively working on the conversation.</p>
         */
        @JsonSetter(value = "adjusted_handling_time", nulls = Nulls.SKIP)
        public Builder adjustedHandlingTime(Optional<Integer> adjustedHandlingTime) {
            this.adjustedHandlingTime = adjustedHandlingTime;
            return this;
        }

        public Builder adjustedHandlingTime(Integer adjustedHandlingTime) {
            this.adjustedHandlingTime = Optional.ofNullable(adjustedHandlingTime);
            return this;
        }

        public ConversationStatistics build() {
            return new ConversationStatistics(
                    type,
                    timeToAssignment,
                    timeToAdminReply,
                    timeToFirstClose,
                    timeToLastClose,
                    medianTimeToReply,
                    firstContactReplyAt,
                    firstAssignmentAt,
                    firstAdminReplyAt,
                    firstCloseAt,
                    lastAssignmentAt,
                    lastAssignmentAdminReplyAt,
                    lastContactReplyAt,
                    lastAdminReplyAt,
                    lastCloseAt,
                    lastClosedById,
                    countReopens,
                    countAssignments,
                    countConversationParts,
                    assignedTeamFirstResponseTimeByTeam,
                    assignedTeamFirstResponseTimeInOfficeHours,
                    handlingTime,
                    adjustedHandlingTime,
                    additionalProperties);
        }
    }
}
