/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomChannelAttribute.Builder.class)
public final class CustomChannelAttribute {
    private final String id;

    private final String value;

    private final Map<String, Object> additionalProperties;

    private CustomChannelAttribute(String id, String value, Map<String, Object> additionalProperties) {
        this.id = id;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Identifier for the attribute being collected.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return Value provided by the user for the attribute.
     */
    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomChannelAttribute && equalTo((CustomChannelAttribute) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelAttribute other) {
        return id.equals(other.id) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>Identifier for the attribute being collected.</p>
         */
        ValueStage id(@NotNull String id);

        Builder from(CustomChannelAttribute other);
    }

    public interface ValueStage {
        /**
         * <p>Value provided by the user for the attribute.</p>
         */
        _FinalStage value(@NotNull String value);
    }

    public interface _FinalStage {
        CustomChannelAttribute build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, ValueStage, _FinalStage {
        private String id;

        private String value;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CustomChannelAttribute other) {
            id(other.getId());
            value(other.getValue());
            return this;
        }

        /**
         * <p>Identifier for the attribute being collected.</p>
         * <p>Identifier for the attribute being collected.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public ValueStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Value provided by the user for the attribute.</p>
         * <p>Value provided by the user for the attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @java.lang.Override
        public CustomChannelAttribute build() {
            return new CustomChannelAttribute(id, value, additionalProperties);
        }
    }
}
