/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomChannelBaseEvent.Builder.class)
public final class CustomChannelBaseEvent implements ICustomChannelBaseEvent {
    private final String eventId;

    private final String externalConversationId;

    private final CustomChannelContact contact;

    private final Map<String, Object> additionalProperties;

    private CustomChannelBaseEvent(
            String eventId,
            String externalConversationId,
            CustomChannelContact contact,
            Map<String, Object> additionalProperties) {
        this.eventId = eventId;
        this.externalConversationId = externalConversationId;
        this.contact = contact;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Unique identifier for the event.
     */
    @JsonProperty("event_id")
    public String getEventId() {
        return eventId;
    }

    /**
     * @return Identifier for the conversation in your application.
     */
    @JsonProperty("external_conversation_id")
    public String getExternalConversationId() {
        return externalConversationId;
    }

    @JsonProperty("contact")
    public CustomChannelContact getContact() {
        return contact;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomChannelBaseEvent && equalTo((CustomChannelBaseEvent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelBaseEvent other) {
        return eventId.equals(other.eventId)
                && externalConversationId.equals(other.externalConversationId)
                && contact.equals(other.contact);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.eventId, this.externalConversationId, this.contact);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventIdStage builder() {
        return new Builder();
    }

    public interface EventIdStage {
        /**
         * <p>Unique identifier for the event.</p>
         */
        ExternalConversationIdStage eventId(@NotNull String eventId);

        Builder from(CustomChannelBaseEvent other);
    }

    public interface ExternalConversationIdStage {
        /**
         * <p>Identifier for the conversation in your application.</p>
         */
        ContactStage externalConversationId(@NotNull String externalConversationId);
    }

    public interface ContactStage {
        _FinalStage contact(@NotNull CustomChannelContact contact);
    }

    public interface _FinalStage {
        CustomChannelBaseEvent build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements EventIdStage, ExternalConversationIdStage, ContactStage, _FinalStage {
        private String eventId;

        private String externalConversationId;

        private CustomChannelContact contact;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CustomChannelBaseEvent other) {
            eventId(other.getEventId());
            externalConversationId(other.getExternalConversationId());
            contact(other.getContact());
            return this;
        }

        /**
         * <p>Unique identifier for the event.</p>
         * <p>Unique identifier for the event.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("event_id")
        public ExternalConversationIdStage eventId(@NotNull String eventId) {
            this.eventId = Objects.requireNonNull(eventId, "eventId must not be null");
            return this;
        }

        /**
         * <p>Identifier for the conversation in your application.</p>
         * <p>Identifier for the conversation in your application.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_conversation_id")
        public ContactStage externalConversationId(@NotNull String externalConversationId) {
            this.externalConversationId =
                    Objects.requireNonNull(externalConversationId, "externalConversationId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("contact")
        public _FinalStage contact(@NotNull CustomChannelContact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @java.lang.Override
        public CustomChannelBaseEvent build() {
            return new CustomChannelBaseEvent(eventId, externalConversationId, contact, additionalProperties);
        }
    }
}
