/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using = CustomerRequest.Deserializer.class)
public final class CustomerRequest {
    private final Object value;

    private final int type;

    private CustomerRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((IntercomUserId) this.value);
        } else if (this.type == 1) {
            return visitor.visit((UserId) this.value);
        } else if (this.type == 2) {
            return visitor.visit((Email) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomerRequest && equalTo((CustomerRequest) other);
    }

    private boolean equalTo(CustomerRequest other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static CustomerRequest of(IntercomUserId value) {
        return new CustomerRequest(value, 0);
    }

    public static CustomerRequest of(UserId value) {
        return new CustomerRequest(value, 1);
    }

    public static CustomerRequest of(Email value) {
        return new CustomerRequest(value, 2);
    }

    public interface Visitor<T> {
        T visit(IntercomUserId value);

        T visit(UserId value);

        T visit(Email value);
    }

    static final class Deserializer extends StdDeserializer<CustomerRequest> {
        Deserializer() {
            super(CustomerRequest.class);
        }

        @java.lang.Override
        public CustomerRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, IntercomUserId.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, UserId.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, Email.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = IntercomUserId.Builder.class)
    public static final class IntercomUserId {
        private final String intercomUserId;

        private final Map<String, Object> additionalProperties;

        private IntercomUserId(String intercomUserId, Map<String, Object> additionalProperties) {
            this.intercomUserId = intercomUserId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The identifier for the contact as given by Intercom.
         */
        @JsonProperty("intercom_user_id")
        public String getIntercomUserId() {
            return intercomUserId;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof IntercomUserId && equalTo((IntercomUserId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(IntercomUserId other) {
            return intercomUserId.equals(other.intercomUserId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.intercomUserId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IntercomUserIdStage builder() {
            return new Builder();
        }

        public interface IntercomUserIdStage {
            /**
             * <p>The identifier for the contact as given by Intercom.</p>
             */
            _FinalStage intercomUserId(@NotNull String intercomUserId);

            Builder from(IntercomUserId other);
        }

        public interface _FinalStage {
            IntercomUserId build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements IntercomUserIdStage, _FinalStage {
            private String intercomUserId;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(IntercomUserId other) {
                intercomUserId(other.getIntercomUserId());
                return this;
            }

            /**
             * <p>The identifier for the contact as given by Intercom.</p>
             * <p>The identifier for the contact as given by Intercom.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("intercom_user_id")
            public _FinalStage intercomUserId(@NotNull String intercomUserId) {
                this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
                return this;
            }

            @java.lang.Override
            public IntercomUserId build() {
                return new IntercomUserId(intercomUserId, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Email.Builder.class)
    public static final class Email {
        private final String email;

        private final Map<String, Object> additionalProperties;

        private Email(String email, Map<String, Object> additionalProperties) {
            this.email = email;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The email you have defined for the contact who is being added as a participant.
         */
        @JsonProperty("email")
        public String getEmail() {
            return email;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Email && equalTo((Email) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Email other) {
            return email.equals(other.email);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.email);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static EmailStage builder() {
            return new Builder();
        }

        public interface EmailStage {
            /**
             * <p>The email you have defined for the contact who is being added as a participant.</p>
             */
            _FinalStage email(@NotNull String email);

            Builder from(Email other);
        }

        public interface _FinalStage {
            Email build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements EmailStage, _FinalStage {
            private String email;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Email other) {
                email(other.getEmail());
                return this;
            }

            /**
             * <p>The email you have defined for the contact who is being added as a participant.</p>
             * <p>The email you have defined for the contact who is being added as a participant.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("email")
            public _FinalStage email(@NotNull String email) {
                this.email = Objects.requireNonNull(email, "email must not be null");
                return this;
            }

            @java.lang.Override
            public Email build() {
                return new Email(email, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = UserId.Builder.class)
    public static final class UserId {
        private final String userId;

        private final Map<String, Object> additionalProperties;

        private UserId(String userId, Map<String, Object> additionalProperties) {
            this.userId = userId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The external_id you have defined for the contact who is being added as a participant.
         */
        @JsonProperty("user_id")
        public String getUserId() {
            return userId;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof UserId && equalTo((UserId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(UserId other) {
            return userId.equals(other.userId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.userId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static UserIdStage builder() {
            return new Builder();
        }

        public interface UserIdStage {
            /**
             * <p>The external_id you have defined for the contact who is being added as a participant.</p>
             */
            _FinalStage userId(@NotNull String userId);

            Builder from(UserId other);
        }

        public interface _FinalStage {
            UserId build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements UserIdStage, _FinalStage {
            private String userId;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(UserId other) {
                userId(other.getUserId());
                return this;
            }

            /**
             * <p>The external_id you have defined for the contact who is being added as a participant.</p>
             * <p>The external_id you have defined for the contact who is being added as a participant.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("user_id")
            public _FinalStage userId(@NotNull String userId) {
                this.userId = Objects.requireNonNull(userId, "userId must not be null");
                return this;
            }

            @java.lang.Override
            public UserId build() {
                return new UserId(userId, additionalProperties);
            }
        }
    }
}
