/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = RegisterFinVoiceCallRequest.Builder.class)
public final class RegisterFinVoiceCallRequest {
    private final String phoneNumber;

    private final String callId;

    private final Optional<Source> source;

    private final Optional<Map<String, Object>> data;

    private final Map<String, Object> additionalProperties;

    private RegisterFinVoiceCallRequest(
            String phoneNumber,
            String callId,
            Optional<Source> source,
            Optional<Map<String, Object>> data,
            Map<String, Object> additionalProperties) {
        this.phoneNumber = phoneNumber;
        this.callId = callId;
        this.source = source;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Phone number in E.164 format for the call
     */
    @JsonProperty("phone_number")
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * @return External call identifier from the call provider
     */
    @JsonProperty("call_id")
    public String getCallId() {
        return callId;
    }

    /**
     * @return Source of the call. Can be &quot;five9&quot;, &quot;zoom_phone&quot;, or defaults to &quot;aws_connect&quot;
     */
    @JsonProperty("source")
    public Optional<Source> getSource() {
        return source;
    }

    /**
     * @return Additional metadata about the call
     */
    @JsonProperty("data")
    public Optional<Map<String, Object>> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof RegisterFinVoiceCallRequest && equalTo((RegisterFinVoiceCallRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RegisterFinVoiceCallRequest other) {
        return phoneNumber.equals(other.phoneNumber)
                && callId.equals(other.callId)
                && source.equals(other.source)
                && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.phoneNumber, this.callId, this.source, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneNumberStage builder() {
        return new Builder();
    }

    public interface PhoneNumberStage {
        /**
         * <p>Phone number in E.164 format for the call</p>
         */
        CallIdStage phoneNumber(@NotNull String phoneNumber);

        Builder from(RegisterFinVoiceCallRequest other);
    }

    public interface CallIdStage {
        /**
         * <p>External call identifier from the call provider</p>
         */
        _FinalStage callId(@NotNull String callId);
    }

    public interface _FinalStage {
        RegisterFinVoiceCallRequest build();

        /**
         * <p>Source of the call. Can be &quot;five9&quot;, &quot;zoom_phone&quot;, or defaults to &quot;aws_connect&quot;</p>
         */
        _FinalStage source(Optional<Source> source);

        _FinalStage source(Source source);

        /**
         * <p>Additional metadata about the call</p>
         */
        _FinalStage data(Optional<Map<String, Object>> data);

        _FinalStage data(Map<String, Object> data);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PhoneNumberStage, CallIdStage, _FinalStage {
        private String phoneNumber;

        private String callId;

        private Optional<Map<String, Object>> data = Optional.empty();

        private Optional<Source> source = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(RegisterFinVoiceCallRequest other) {
            phoneNumber(other.getPhoneNumber());
            callId(other.getCallId());
            source(other.getSource());
            data(other.getData());
            return this;
        }

        /**
         * <p>Phone number in E.164 format for the call</p>
         * <p>Phone number in E.164 format for the call</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("phone_number")
        public CallIdStage phoneNumber(@NotNull String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber must not be null");
            return this;
        }

        /**
         * <p>External call identifier from the call provider</p>
         * <p>External call identifier from the call provider</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("call_id")
        public _FinalStage callId(@NotNull String callId) {
            this.callId = Objects.requireNonNull(callId, "callId must not be null");
            return this;
        }

        /**
         * <p>Additional metadata about the call</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage data(Map<String, Object> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        /**
         * <p>Additional metadata about the call</p>
         */
        @java.lang.Override
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public _FinalStage data(Optional<Map<String, Object>> data) {
            this.data = data;
            return this;
        }

        /**
         * <p>Source of the call. Can be &quot;five9&quot;, &quot;zoom_phone&quot;, or defaults to &quot;aws_connect&quot;</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage source(Source source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        /**
         * <p>Source of the call. Can be &quot;five9&quot;, &quot;zoom_phone&quot;, or defaults to &quot;aws_connect&quot;</p>
         */
        @java.lang.Override
        @JsonSetter(value = "source", nulls = Nulls.SKIP)
        public _FinalStage source(Optional<Source> source) {
            this.source = source;
            return this;
        }

        @java.lang.Override
        public RegisterFinVoiceCallRequest build() {
            return new RegisterFinVoiceCallRequest(phoneNumber, callId, source, data, additionalProperties);
        }
    }

    public static final class Source {
        public static final Source ZOOM_PHONE = new Source(Value.ZOOM_PHONE, "zoom_phone");

        public static final Source AWS_CONNECT = new Source(Value.AWS_CONNECT, "aws_connect");

        public static final Source FIVE_9 = new Source(Value.FIVE_9, "five9");

        private final Value value;

        private final String string;

        Source(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Source && this.string.equals(((Source) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case ZOOM_PHONE:
                    return visitor.visitZoomPhone();
                case AWS_CONNECT:
                    return visitor.visitAwsConnect();
                case FIVE_9:
                    return visitor.visitFive9();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Source valueOf(String value) {
            switch (value) {
                case "zoom_phone":
                    return ZOOM_PHONE;
                case "aws_connect":
                    return AWS_CONNECT;
                case "five9":
                    return FIVE_9;
                default:
                    return new Source(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            FIVE_9,

            ZOOM_PHONE,

            AWS_CONNECT,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitFive9();

            T visitZoomPhone();

            T visitAwsConnect();

            T visitUnknown(String unknownType);
        }
    }
}
