/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using = UpdateDataAttributeRequestBody.Deserializer.class)
public final class UpdateDataAttributeRequestBody {
    private final Object value;

    private final int type;

    private UpdateDataAttributeRequestBody(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((UpdateDataAttributeRequestOptions) this.value);
        } else if (this.type == 1) {
            return visitor.visit((Object) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateDataAttributeRequestBody && equalTo((UpdateDataAttributeRequestBody) other);
    }

    private boolean equalTo(UpdateDataAttributeRequestBody other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static UpdateDataAttributeRequestBody of(UpdateDataAttributeRequestOptions value) {
        return new UpdateDataAttributeRequestBody(value, 0);
    }

    public static UpdateDataAttributeRequestBody of(Object value) {
        return new UpdateDataAttributeRequestBody(value, 1);
    }

    public interface Visitor<T> {
        T visit(UpdateDataAttributeRequestOptions value);

        T visit(Object value);
    }

    static final class Deserializer extends StdDeserializer<UpdateDataAttributeRequestBody> {
        Deserializer() {
            super(UpdateDataAttributeRequestBody.class);
        }

        @java.lang.Override
        public UpdateDataAttributeRequestBody deserialize(JsonParser p, DeserializationContext context)
                throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, UpdateDataAttributeRequestOptions.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, Object.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = UpdateDataAttributeRequestOptions.Builder.class)
    public static final class UpdateDataAttributeRequestOptions {
        private final List<OptionsItem> options;

        private final Map<String, Object> additionalProperties;

        private UpdateDataAttributeRequestOptions(List<OptionsItem> options, Map<String, Object> additionalProperties) {
            this.options = options;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Array of objects representing the options of the list, with <code>value</code> as the key and the option as the value. At least two options are required.
         */
        @JsonProperty("options")
        public List<OptionsItem> getOptions() {
            return options;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof UpdateDataAttributeRequestOptions
                    && equalTo((UpdateDataAttributeRequestOptions) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(UpdateDataAttributeRequestOptions other) {
            return options.equals(other.options);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.options);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private List<OptionsItem> options = new ArrayList<>();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(UpdateDataAttributeRequestOptions other) {
                options(other.getOptions());
                return this;
            }

            /**
             * <p>Array of objects representing the options of the list, with <code>value</code> as the key and the option as the value. At least two options are required.</p>
             */
            @JsonSetter(value = "options", nulls = Nulls.SKIP)
            public Builder options(List<OptionsItem> options) {
                this.options.clear();
                if (options != null) {
                    this.options.addAll(options);
                }
                return this;
            }

            public Builder addOptions(OptionsItem options) {
                this.options.add(options);
                return this;
            }

            public Builder addAllOptions(List<OptionsItem> options) {
                if (options != null) {
                    this.options.addAll(options);
                }
                return this;
            }

            public UpdateDataAttributeRequestOptions build() {
                return new UpdateDataAttributeRequestOptions(options, additionalProperties);
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = OptionsItem.Builder.class)
        public static final class OptionsItem {
            private final Optional<String> value;

            private final Map<String, Object> additionalProperties;

            private OptionsItem(Optional<String> value, Map<String, Object> additionalProperties) {
                this.value = value;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty("value")
            public Optional<String> getValue() {
                return value;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof OptionsItem && equalTo((OptionsItem) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(OptionsItem other) {
                return value.equals(other.value);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.value);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder {
                private Optional<String> value = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                public Builder from(OptionsItem other) {
                    value(other.getValue());
                    return this;
                }

                @JsonSetter(value = "value", nulls = Nulls.SKIP)
                public Builder value(Optional<String> value) {
                    this.value = value;
                    return this;
                }

                public Builder value(String value) {
                    this.value = Optional.ofNullable(value);
                    return this;
                }

                public OptionsItem build() {
                    return new OptionsItem(value, additionalProperties);
                }
            }
        }
    }
}
