/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.workflows;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.ForbiddenError;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.WorkflowExport;
import com.intercom.api.resources.unstable.workflows.requests.ExportWorkflowRequest;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawWorkflowsClient {
    protected final ClientOptions clientOptions;

    public RawWorkflowsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Export a workflow configuration by its ID. This endpoint returns the complete workflow definition including its steps, targeting rules, and attributes.
     * <p>This endpoint is designed for EU Data Act compliance, allowing customers to export their workflow configurations.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Unstable API&quot; %}
     * This API is currently in the Unstable version. Its behavior may change in future releases.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<WorkflowExport> exportWorkflow(ExportWorkflowRequest request) {
        return exportWorkflow(request, null);
    }

    /**
     * Export a workflow configuration by its ID. This endpoint returns the complete workflow definition including its steps, targeting rules, and attributes.
     * <p>This endpoint is designed for EU Data Act compliance, allowing customers to export their workflow configurations.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Unstable API&quot; %}
     * This API is currently in the Unstable version. Its behavior may change in future releases.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<WorkflowExport> exportWorkflow(
            ExportWorkflowRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("export/workflows")
                .addPathSegment(request.getId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, WorkflowExport.class), response);
            }
            try {
                switch (response.code()) {
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
