/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.workflows;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.types.WorkflowExport;
import com.intercom.api.resources.unstable.workflows.requests.ExportWorkflowRequest;

public class WorkflowsClient {
    protected final ClientOptions clientOptions;

    private final RawWorkflowsClient rawClient;

    public WorkflowsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawWorkflowsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawWorkflowsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Export a workflow configuration by its ID. This endpoint returns the complete workflow definition including its steps, targeting rules, and attributes.
     * <p>This endpoint is designed for EU Data Act compliance, allowing customers to export their workflow configurations.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Unstable API&quot; %}
     * This API is currently in the Unstable version. Its behavior may change in future releases.
     * {% /admonition %}</p>
     */
    public WorkflowExport exportWorkflow(ExportWorkflowRequest request) {
        return this.rawClient.exportWorkflow(request).body();
    }

    /**
     * Export a workflow configuration by its ID. This endpoint returns the complete workflow definition including its steps, targeting rules, and attributes.
     * <p>This endpoint is designed for EU Data Act compliance, allowing customers to export their workflow configurations.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Unstable API&quot; %}
     * This API is currently in the Unstable version. Its behavior may change in future releases.
     * {% /admonition %}</p>
     */
    public WorkflowExport exportWorkflow(ExportWorkflowRequest request, RequestOptions requestOptions) {
        return this.rawClient.exportWorkflow(request, requestOptions).body();
    }
}
