/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationTeammates.Builder.class)
public final class ConversationTeammates {
    private final List<Reference> admins;

    private final Map<String, Object> additionalProperties;

    private ConversationTeammates(List<Reference> admins, Map<String, Object> additionalProperties) {
        this.admins = admins;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - <code>admin.list</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "admin.list";
    }

    /**
     * @return The list of teammates who participated in the conversation (wrote at least one conversation part).
     */
    @JsonProperty("admins")
    public List<Reference> getAdmins() {
        return admins;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationTeammates && equalTo((ConversationTeammates) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationTeammates other) {
        return admins.equals(other.admins);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.admins);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Reference> admins = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationTeammates other) {
            admins(other.getAdmins());
            return this;
        }

        /**
         * <p>The list of teammates who participated in the conversation (wrote at least one conversation part).</p>
         */
        @JsonSetter(value = "admins", nulls = Nulls.SKIP)
        public Builder admins(List<Reference> admins) {
            this.admins.clear();
            if (admins != null) {
                this.admins.addAll(admins);
            }
            return this;
        }

        public Builder addAdmins(Reference admins) {
            this.admins.add(admins);
            return this;
        }

        public Builder addAllAdmins(List<Reference> admins) {
            if (admins != null) {
                this.admins.addAll(admins);
            }
            return this;
        }

        public ConversationTeammates build() {
            return new ConversationTeammates(admins, additionalProperties);
        }
    }
}
