/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using = CreateContactRequest.Deserializer.class)
public final class CreateContactRequest {
    private final Object value;

    private final int type;

    private CreateContactRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((WithEmail) this.value);
        } else if (this.type == 1) {
            return visitor.visit((WithExternalId) this.value);
        } else if (this.type == 2) {
            return visitor.visit((WithRole) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateContactRequest && equalTo((CreateContactRequest) other);
    }

    private boolean equalTo(CreateContactRequest other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static CreateContactRequest of(WithEmail value) {
        return new CreateContactRequest(value, 0);
    }

    public static CreateContactRequest of(WithExternalId value) {
        return new CreateContactRequest(value, 1);
    }

    public static CreateContactRequest of(WithRole value) {
        return new CreateContactRequest(value, 2);
    }

    public interface Visitor<T> {
        T visit(WithEmail value);

        T visit(WithExternalId value);

        T visit(WithRole value);
    }

    static final class Deserializer extends StdDeserializer<CreateContactRequest> {
        Deserializer() {
            super(CreateContactRequest.class);
        }

        @java.lang.Override
        public CreateContactRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithEmail.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithExternalId.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, WithRole.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithEmail.Builder.class)
    public static final class WithEmail {
        private final String email;

        private final Optional<String> phone;

        private final Optional<String> name;

        private final Optional<String> avatar;

        private final Optional<Integer> signedUpAt;

        private final Optional<Integer> lastSeenAt;

        private final Optional<Integer> ownerId;

        private final Optional<Boolean> unsubscribedFromEmails;

        private final Optional<Map<String, Object>> customAttributes;

        private final Map<String, Object> additionalProperties;

        private WithEmail(
                String email,
                Optional<String> phone,
                Optional<String> name,
                Optional<String> avatar,
                Optional<Integer> signedUpAt,
                Optional<Integer> lastSeenAt,
                Optional<Integer> ownerId,
                Optional<Boolean> unsubscribedFromEmails,
                Optional<Map<String, Object>> customAttributes,
                Map<String, Object> additionalProperties) {
            this.email = email;
            this.phone = phone;
            this.name = name;
            this.avatar = avatar;
            this.signedUpAt = signedUpAt;
            this.lastSeenAt = lastSeenAt;
            this.ownerId = ownerId;
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The contacts email
         */
        @JsonProperty("email")
        public String getEmail() {
            return email;
        }

        /**
         * @return The contacts phone
         */
        @JsonProperty("phone")
        public Optional<String> getPhone() {
            return phone;
        }

        /**
         * @return The contacts name
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        /**
         * @return An image URL containing the avatar of a contact
         */
        @JsonProperty("avatar")
        public Optional<String> getAvatar() {
            return avatar;
        }

        /**
         * @return The time specified for when a contact signed up
         */
        @JsonProperty("signed_up_at")
        public Optional<Integer> getSignedUpAt() {
            return signedUpAt;
        }

        /**
         * @return The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
         */
        @JsonProperty("last_seen_at")
        public Optional<Integer> getLastSeenAt() {
            return lastSeenAt;
        }

        /**
         * @return The id of an admin that has been assigned account ownership of the contact
         */
        @JsonProperty("owner_id")
        public Optional<Integer> getOwnerId() {
            return ownerId;
        }

        /**
         * @return Whether the contact is unsubscribed from emails
         */
        @JsonProperty("unsubscribed_from_emails")
        public Optional<Boolean> getUnsubscribedFromEmails() {
            return unsubscribedFromEmails;
        }

        /**
         * @return The custom attributes which are set for the contact
         */
        @JsonProperty("custom_attributes")
        public Optional<Map<String, Object>> getCustomAttributes() {
            return customAttributes;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithEmail && equalTo((WithEmail) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithEmail other) {
            return email.equals(other.email)
                    && phone.equals(other.phone)
                    && name.equals(other.name)
                    && avatar.equals(other.avatar)
                    && signedUpAt.equals(other.signedUpAt)
                    && lastSeenAt.equals(other.lastSeenAt)
                    && ownerId.equals(other.ownerId)
                    && unsubscribedFromEmails.equals(other.unsubscribedFromEmails)
                    && customAttributes.equals(other.customAttributes);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.email,
                    this.phone,
                    this.name,
                    this.avatar,
                    this.signedUpAt,
                    this.lastSeenAt,
                    this.ownerId,
                    this.unsubscribedFromEmails,
                    this.customAttributes);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static EmailStage builder() {
            return new Builder();
        }

        public interface EmailStage {
            /**
             * <p>The contacts email</p>
             */
            _FinalStage email(@NotNull String email);

            Builder from(WithEmail other);
        }

        public interface _FinalStage {
            WithEmail build();

            /**
             * <p>The contacts phone</p>
             */
            _FinalStage phone(Optional<String> phone);

            _FinalStage phone(String phone);

            /**
             * <p>The contacts name</p>
             */
            _FinalStage name(Optional<String> name);

            _FinalStage name(String name);

            /**
             * <p>An image URL containing the avatar of a contact</p>
             */
            _FinalStage avatar(Optional<String> avatar);

            _FinalStage avatar(String avatar);

            /**
             * <p>The time specified for when a contact signed up</p>
             */
            _FinalStage signedUpAt(Optional<Integer> signedUpAt);

            _FinalStage signedUpAt(Integer signedUpAt);

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             */
            _FinalStage lastSeenAt(Optional<Integer> lastSeenAt);

            _FinalStage lastSeenAt(Integer lastSeenAt);

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             */
            _FinalStage ownerId(Optional<Integer> ownerId);

            _FinalStage ownerId(Integer ownerId);

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             */
            _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails);

            _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails);

            /**
             * <p>The custom attributes which are set for the contact</p>
             */
            _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

            _FinalStage customAttributes(Map<String, Object> customAttributes);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements EmailStage, _FinalStage {
            private String email;

            private Optional<Map<String, Object>> customAttributes = Optional.empty();

            private Optional<Boolean> unsubscribedFromEmails = Optional.empty();

            private Optional<Integer> ownerId = Optional.empty();

            private Optional<Integer> lastSeenAt = Optional.empty();

            private Optional<Integer> signedUpAt = Optional.empty();

            private Optional<String> avatar = Optional.empty();

            private Optional<String> name = Optional.empty();

            private Optional<String> phone = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithEmail other) {
                email(other.getEmail());
                phone(other.getPhone());
                name(other.getName());
                avatar(other.getAvatar());
                signedUpAt(other.getSignedUpAt());
                lastSeenAt(other.getLastSeenAt());
                ownerId(other.getOwnerId());
                unsubscribedFromEmails(other.getUnsubscribedFromEmails());
                customAttributes(other.getCustomAttributes());
                return this;
            }

            /**
             * <p>The contacts email</p>
             * <p>The contacts email</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("email")
            public _FinalStage email(@NotNull String email) {
                this.email = Objects.requireNonNull(email, "email must not be null");
                return this;
            }

            /**
             * <p>The custom attributes which are set for the contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage customAttributes(Map<String, Object> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            /**
             * <p>The custom attributes which are set for the contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
                this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
                return this;
            }

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             */
            @java.lang.Override
            @JsonSetter(value = "unsubscribed_from_emails", nulls = Nulls.SKIP)
            public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
                this.unsubscribedFromEmails = unsubscribedFromEmails;
                return this;
            }

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage ownerId(Integer ownerId) {
                this.ownerId = Optional.ofNullable(ownerId);
                return this;
            }

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
            public _FinalStage ownerId(Optional<Integer> ownerId) {
                this.ownerId = ownerId;
                return this;
            }

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage lastSeenAt(Integer lastSeenAt) {
                this.lastSeenAt = Optional.ofNullable(lastSeenAt);
                return this;
            }

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             */
            @java.lang.Override
            @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
            public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
                this.lastSeenAt = lastSeenAt;
                return this;
            }

            /**
             * <p>The time specified for when a contact signed up</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage signedUpAt(Integer signedUpAt) {
                this.signedUpAt = Optional.ofNullable(signedUpAt);
                return this;
            }

            /**
             * <p>The time specified for when a contact signed up</p>
             */
            @java.lang.Override
            @JsonSetter(value = "signed_up_at", nulls = Nulls.SKIP)
            public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
                this.signedUpAt = signedUpAt;
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage avatar(String avatar) {
                this.avatar = Optional.ofNullable(avatar);
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
            public _FinalStage avatar(Optional<String> avatar) {
                this.avatar = avatar;
                return this;
            }

            /**
             * <p>The contacts name</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            /**
             * <p>The contacts name</p>
             */
            @java.lang.Override
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            /**
             * <p>The contacts phone</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            /**
             * <p>The contacts phone</p>
             */
            @java.lang.Override
            @JsonSetter(value = "phone", nulls = Nulls.SKIP)
            public _FinalStage phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            @java.lang.Override
            public WithEmail build() {
                return new WithEmail(
                        email,
                        phone,
                        name,
                        avatar,
                        signedUpAt,
                        lastSeenAt,
                        ownerId,
                        unsubscribedFromEmails,
                        customAttributes,
                        additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithRole.Builder.class)
    public static final class WithRole {
        private final String role;

        private final Optional<String> phone;

        private final Optional<String> name;

        private final Optional<String> avatar;

        private final Optional<Integer> signedUpAt;

        private final Optional<Integer> lastSeenAt;

        private final Optional<Integer> ownerId;

        private final Optional<Boolean> unsubscribedFromEmails;

        private final Optional<Map<String, Object>> customAttributes;

        private final Map<String, Object> additionalProperties;

        private WithRole(
                String role,
                Optional<String> phone,
                Optional<String> name,
                Optional<String> avatar,
                Optional<Integer> signedUpAt,
                Optional<Integer> lastSeenAt,
                Optional<Integer> ownerId,
                Optional<Boolean> unsubscribedFromEmails,
                Optional<Map<String, Object>> customAttributes,
                Map<String, Object> additionalProperties) {
            this.role = role;
            this.phone = phone;
            this.name = name;
            this.avatar = avatar;
            this.signedUpAt = signedUpAt;
            this.lastSeenAt = lastSeenAt;
            this.ownerId = ownerId;
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The role of the contact.
         */
        @JsonProperty("role")
        public String getRole() {
            return role;
        }

        /**
         * @return The contacts phone
         */
        @JsonProperty("phone")
        public Optional<String> getPhone() {
            return phone;
        }

        /**
         * @return The contacts name
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        /**
         * @return An image URL containing the avatar of a contact
         */
        @JsonProperty("avatar")
        public Optional<String> getAvatar() {
            return avatar;
        }

        /**
         * @return The time specified for when a contact signed up
         */
        @JsonProperty("signed_up_at")
        public Optional<Integer> getSignedUpAt() {
            return signedUpAt;
        }

        /**
         * @return The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
         */
        @JsonProperty("last_seen_at")
        public Optional<Integer> getLastSeenAt() {
            return lastSeenAt;
        }

        /**
         * @return The id of an admin that has been assigned account ownership of the contact
         */
        @JsonProperty("owner_id")
        public Optional<Integer> getOwnerId() {
            return ownerId;
        }

        /**
         * @return Whether the contact is unsubscribed from emails
         */
        @JsonProperty("unsubscribed_from_emails")
        public Optional<Boolean> getUnsubscribedFromEmails() {
            return unsubscribedFromEmails;
        }

        /**
         * @return The custom attributes which are set for the contact
         */
        @JsonProperty("custom_attributes")
        public Optional<Map<String, Object>> getCustomAttributes() {
            return customAttributes;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithRole && equalTo((WithRole) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithRole other) {
            return role.equals(other.role)
                    && phone.equals(other.phone)
                    && name.equals(other.name)
                    && avatar.equals(other.avatar)
                    && signedUpAt.equals(other.signedUpAt)
                    && lastSeenAt.equals(other.lastSeenAt)
                    && ownerId.equals(other.ownerId)
                    && unsubscribedFromEmails.equals(other.unsubscribedFromEmails)
                    && customAttributes.equals(other.customAttributes);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.role,
                    this.phone,
                    this.name,
                    this.avatar,
                    this.signedUpAt,
                    this.lastSeenAt,
                    this.ownerId,
                    this.unsubscribedFromEmails,
                    this.customAttributes);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static RoleStage builder() {
            return new Builder();
        }

        public interface RoleStage {
            /**
             * <p>The role of the contact.</p>
             */
            _FinalStage role(@NotNull String role);

            Builder from(WithRole other);
        }

        public interface _FinalStage {
            WithRole build();

            /**
             * <p>The contacts phone</p>
             */
            _FinalStage phone(Optional<String> phone);

            _FinalStage phone(String phone);

            /**
             * <p>The contacts name</p>
             */
            _FinalStage name(Optional<String> name);

            _FinalStage name(String name);

            /**
             * <p>An image URL containing the avatar of a contact</p>
             */
            _FinalStage avatar(Optional<String> avatar);

            _FinalStage avatar(String avatar);

            /**
             * <p>The time specified for when a contact signed up</p>
             */
            _FinalStage signedUpAt(Optional<Integer> signedUpAt);

            _FinalStage signedUpAt(Integer signedUpAt);

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             */
            _FinalStage lastSeenAt(Optional<Integer> lastSeenAt);

            _FinalStage lastSeenAt(Integer lastSeenAt);

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             */
            _FinalStage ownerId(Optional<Integer> ownerId);

            _FinalStage ownerId(Integer ownerId);

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             */
            _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails);

            _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails);

            /**
             * <p>The custom attributes which are set for the contact</p>
             */
            _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

            _FinalStage customAttributes(Map<String, Object> customAttributes);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements RoleStage, _FinalStage {
            private String role;

            private Optional<Map<String, Object>> customAttributes = Optional.empty();

            private Optional<Boolean> unsubscribedFromEmails = Optional.empty();

            private Optional<Integer> ownerId = Optional.empty();

            private Optional<Integer> lastSeenAt = Optional.empty();

            private Optional<Integer> signedUpAt = Optional.empty();

            private Optional<String> avatar = Optional.empty();

            private Optional<String> name = Optional.empty();

            private Optional<String> phone = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithRole other) {
                role(other.getRole());
                phone(other.getPhone());
                name(other.getName());
                avatar(other.getAvatar());
                signedUpAt(other.getSignedUpAt());
                lastSeenAt(other.getLastSeenAt());
                ownerId(other.getOwnerId());
                unsubscribedFromEmails(other.getUnsubscribedFromEmails());
                customAttributes(other.getCustomAttributes());
                return this;
            }

            /**
             * <p>The role of the contact.</p>
             * <p>The role of the contact.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("role")
            public _FinalStage role(@NotNull String role) {
                this.role = Objects.requireNonNull(role, "role must not be null");
                return this;
            }

            /**
             * <p>The custom attributes which are set for the contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage customAttributes(Map<String, Object> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            /**
             * <p>The custom attributes which are set for the contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
                this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
                return this;
            }

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             */
            @java.lang.Override
            @JsonSetter(value = "unsubscribed_from_emails", nulls = Nulls.SKIP)
            public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
                this.unsubscribedFromEmails = unsubscribedFromEmails;
                return this;
            }

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage ownerId(Integer ownerId) {
                this.ownerId = Optional.ofNullable(ownerId);
                return this;
            }

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
            public _FinalStage ownerId(Optional<Integer> ownerId) {
                this.ownerId = ownerId;
                return this;
            }

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage lastSeenAt(Integer lastSeenAt) {
                this.lastSeenAt = Optional.ofNullable(lastSeenAt);
                return this;
            }

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             */
            @java.lang.Override
            @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
            public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
                this.lastSeenAt = lastSeenAt;
                return this;
            }

            /**
             * <p>The time specified for when a contact signed up</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage signedUpAt(Integer signedUpAt) {
                this.signedUpAt = Optional.ofNullable(signedUpAt);
                return this;
            }

            /**
             * <p>The time specified for when a contact signed up</p>
             */
            @java.lang.Override
            @JsonSetter(value = "signed_up_at", nulls = Nulls.SKIP)
            public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
                this.signedUpAt = signedUpAt;
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage avatar(String avatar) {
                this.avatar = Optional.ofNullable(avatar);
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
            public _FinalStage avatar(Optional<String> avatar) {
                this.avatar = avatar;
                return this;
            }

            /**
             * <p>The contacts name</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            /**
             * <p>The contacts name</p>
             */
            @java.lang.Override
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            /**
             * <p>The contacts phone</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            /**
             * <p>The contacts phone</p>
             */
            @java.lang.Override
            @JsonSetter(value = "phone", nulls = Nulls.SKIP)
            public _FinalStage phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            @java.lang.Override
            public WithRole build() {
                return new WithRole(
                        role,
                        phone,
                        name,
                        avatar,
                        signedUpAt,
                        lastSeenAt,
                        ownerId,
                        unsubscribedFromEmails,
                        customAttributes,
                        additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = WithExternalId.Builder.class)
    public static final class WithExternalId {
        private final String externalId;

        private final Optional<String> phone;

        private final Optional<String> name;

        private final Optional<String> avatar;

        private final Optional<Integer> signedUpAt;

        private final Optional<Integer> lastSeenAt;

        private final Optional<Integer> ownerId;

        private final Optional<Boolean> unsubscribedFromEmails;

        private final Optional<Map<String, Object>> customAttributes;

        private final Map<String, Object> additionalProperties;

        private WithExternalId(
                String externalId,
                Optional<String> phone,
                Optional<String> name,
                Optional<String> avatar,
                Optional<Integer> signedUpAt,
                Optional<Integer> lastSeenAt,
                Optional<Integer> ownerId,
                Optional<Boolean> unsubscribedFromEmails,
                Optional<Map<String, Object>> customAttributes,
                Map<String, Object> additionalProperties) {
            this.externalId = externalId;
            this.phone = phone;
            this.name = name;
            this.avatar = avatar;
            this.signedUpAt = signedUpAt;
            this.lastSeenAt = lastSeenAt;
            this.ownerId = ownerId;
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            this.customAttributes = customAttributes;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return A unique identifier for the contact which is given to Intercom
         */
        @JsonProperty("external_id")
        public String getExternalId() {
            return externalId;
        }

        /**
         * @return The contacts phone
         */
        @JsonProperty("phone")
        public Optional<String> getPhone() {
            return phone;
        }

        /**
         * @return The contacts name
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        /**
         * @return An image URL containing the avatar of a contact
         */
        @JsonProperty("avatar")
        public Optional<String> getAvatar() {
            return avatar;
        }

        /**
         * @return The time specified for when a contact signed up
         */
        @JsonProperty("signed_up_at")
        public Optional<Integer> getSignedUpAt() {
            return signedUpAt;
        }

        /**
         * @return The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
         */
        @JsonProperty("last_seen_at")
        public Optional<Integer> getLastSeenAt() {
            return lastSeenAt;
        }

        /**
         * @return The id of an admin that has been assigned account ownership of the contact
         */
        @JsonProperty("owner_id")
        public Optional<Integer> getOwnerId() {
            return ownerId;
        }

        /**
         * @return Whether the contact is unsubscribed from emails
         */
        @JsonProperty("unsubscribed_from_emails")
        public Optional<Boolean> getUnsubscribedFromEmails() {
            return unsubscribedFromEmails;
        }

        /**
         * @return The custom attributes which are set for the contact
         */
        @JsonProperty("custom_attributes")
        public Optional<Map<String, Object>> getCustomAttributes() {
            return customAttributes;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof WithExternalId && equalTo((WithExternalId) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithExternalId other) {
            return externalId.equals(other.externalId)
                    && phone.equals(other.phone)
                    && name.equals(other.name)
                    && avatar.equals(other.avatar)
                    && signedUpAt.equals(other.signedUpAt)
                    && lastSeenAt.equals(other.lastSeenAt)
                    && ownerId.equals(other.ownerId)
                    && unsubscribedFromEmails.equals(other.unsubscribedFromEmails)
                    && customAttributes.equals(other.customAttributes);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.externalId,
                    this.phone,
                    this.name,
                    this.avatar,
                    this.signedUpAt,
                    this.lastSeenAt,
                    this.ownerId,
                    this.unsubscribedFromEmails,
                    this.customAttributes);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ExternalIdStage builder() {
            return new Builder();
        }

        public interface ExternalIdStage {
            /**
             * <p>A unique identifier for the contact which is given to Intercom</p>
             */
            _FinalStage externalId(@NotNull String externalId);

            Builder from(WithExternalId other);
        }

        public interface _FinalStage {
            WithExternalId build();

            /**
             * <p>The contacts phone</p>
             */
            _FinalStage phone(Optional<String> phone);

            _FinalStage phone(String phone);

            /**
             * <p>The contacts name</p>
             */
            _FinalStage name(Optional<String> name);

            _FinalStage name(String name);

            /**
             * <p>An image URL containing the avatar of a contact</p>
             */
            _FinalStage avatar(Optional<String> avatar);

            _FinalStage avatar(String avatar);

            /**
             * <p>The time specified for when a contact signed up</p>
             */
            _FinalStage signedUpAt(Optional<Integer> signedUpAt);

            _FinalStage signedUpAt(Integer signedUpAt);

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             */
            _FinalStage lastSeenAt(Optional<Integer> lastSeenAt);

            _FinalStage lastSeenAt(Integer lastSeenAt);

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             */
            _FinalStage ownerId(Optional<Integer> ownerId);

            _FinalStage ownerId(Integer ownerId);

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             */
            _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails);

            _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails);

            /**
             * <p>The custom attributes which are set for the contact</p>
             */
            _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

            _FinalStage customAttributes(Map<String, Object> customAttributes);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements ExternalIdStage, _FinalStage {
            private String externalId;

            private Optional<Map<String, Object>> customAttributes = Optional.empty();

            private Optional<Boolean> unsubscribedFromEmails = Optional.empty();

            private Optional<Integer> ownerId = Optional.empty();

            private Optional<Integer> lastSeenAt = Optional.empty();

            private Optional<Integer> signedUpAt = Optional.empty();

            private Optional<String> avatar = Optional.empty();

            private Optional<String> name = Optional.empty();

            private Optional<String> phone = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(WithExternalId other) {
                externalId(other.getExternalId());
                phone(other.getPhone());
                name(other.getName());
                avatar(other.getAvatar());
                signedUpAt(other.getSignedUpAt());
                lastSeenAt(other.getLastSeenAt());
                ownerId(other.getOwnerId());
                unsubscribedFromEmails(other.getUnsubscribedFromEmails());
                customAttributes(other.getCustomAttributes());
                return this;
            }

            /**
             * <p>A unique identifier for the contact which is given to Intercom</p>
             * <p>A unique identifier for the contact which is given to Intercom</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("external_id")
            public _FinalStage externalId(@NotNull String externalId) {
                this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
                return this;
            }

            /**
             * <p>The custom attributes which are set for the contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage customAttributes(Map<String, Object> customAttributes) {
                this.customAttributes = Optional.ofNullable(customAttributes);
                return this;
            }

            /**
             * <p>The custom attributes which are set for the contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
            public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
                this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
                return this;
            }

            /**
             * <p>Whether the contact is unsubscribed from emails</p>
             */
            @java.lang.Override
            @JsonSetter(value = "unsubscribed_from_emails", nulls = Nulls.SKIP)
            public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
                this.unsubscribedFromEmails = unsubscribedFromEmails;
                return this;
            }

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage ownerId(Integer ownerId) {
                this.ownerId = Optional.ofNullable(ownerId);
                return this;
            }

            /**
             * <p>The id of an admin that has been assigned account ownership of the contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
            public _FinalStage ownerId(Optional<Integer> ownerId) {
                this.ownerId = ownerId;
                return this;
            }

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage lastSeenAt(Integer lastSeenAt) {
                this.lastSeenAt = Optional.ofNullable(lastSeenAt);
                return this;
            }

            /**
             * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
             */
            @java.lang.Override
            @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
            public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
                this.lastSeenAt = lastSeenAt;
                return this;
            }

            /**
             * <p>The time specified for when a contact signed up</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage signedUpAt(Integer signedUpAt) {
                this.signedUpAt = Optional.ofNullable(signedUpAt);
                return this;
            }

            /**
             * <p>The time specified for when a contact signed up</p>
             */
            @java.lang.Override
            @JsonSetter(value = "signed_up_at", nulls = Nulls.SKIP)
            public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
                this.signedUpAt = signedUpAt;
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage avatar(String avatar) {
                this.avatar = Optional.ofNullable(avatar);
                return this;
            }

            /**
             * <p>An image URL containing the avatar of a contact</p>
             */
            @java.lang.Override
            @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
            public _FinalStage avatar(Optional<String> avatar) {
                this.avatar = avatar;
                return this;
            }

            /**
             * <p>The contacts name</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            /**
             * <p>The contacts name</p>
             */
            @java.lang.Override
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public _FinalStage name(Optional<String> name) {
                this.name = name;
                return this;
            }

            /**
             * <p>The contacts phone</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage phone(String phone) {
                this.phone = Optional.ofNullable(phone);
                return this;
            }

            /**
             * <p>The contacts phone</p>
             */
            @java.lang.Override
            @JsonSetter(value = "phone", nulls = Nulls.SKIP)
            public _FinalStage phone(Optional<String> phone) {
                this.phone = phone;
                return this;
            }

            @java.lang.Override
            public WithExternalId build() {
                return new WithExternalId(
                        externalId,
                        phone,
                        name,
                        avatar,
                        signedUpAt,
                        lastSeenAt,
                        ownerId,
                        unsubscribedFromEmails,
                        customAttributes,
                        additionalProperties);
            }
        }
    }
}
