/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.customobjectinstances.types.CustomObjectInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomObjectInstanceList.Builder.class)
public final class CustomObjectInstanceList {
    private final Optional<String> type;

    private final Optional<List<Optional<CustomObjectInstance>>> instances;

    private final Map<String, Object> additionalProperties;

    private CustomObjectInstanceList(
            Optional<String> type,
            Optional<List<Optional<CustomObjectInstance>>> instances,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.instances = instances;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The list of associated custom object instances for a given reference attribute on the parent object.
     */
    @JsonProperty("instances")
    public Optional<List<Optional<CustomObjectInstance>>> getInstances() {
        return instances;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomObjectInstanceList && equalTo((CustomObjectInstanceList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomObjectInstanceList other) {
        return type.equals(other.type) && instances.equals(other.instances);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.instances);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Optional<CustomObjectInstance>>> instances = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CustomObjectInstanceList other) {
            type(other.getType());
            instances(other.getInstances());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The list of associated custom object instances for a given reference attribute on the parent object.</p>
         */
        @JsonSetter(value = "instances", nulls = Nulls.SKIP)
        public Builder instances(Optional<List<Optional<CustomObjectInstance>>> instances) {
            this.instances = instances;
            return this;
        }

        public Builder instances(List<Optional<CustomObjectInstance>> instances) {
            this.instances = Optional.ofNullable(instances);
            return this;
        }

        public CustomObjectInstanceList build() {
            return new CustomObjectInstanceList(type, instances, additionalProperties);
        }
    }
}
