/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PhoneSwitch.Builder.class)
public final class PhoneSwitch {
    private final Optional<String> type;

    private final Optional<String> phone;

    private final Map<String, Object> additionalProperties;

    private PhoneSwitch(Optional<String> type, Optional<String> phone, Map<String, Object> additionalProperties) {
        this.type = type;
        this.phone = phone;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.
     */
    @JsonProperty("phone")
    public Optional<String> getPhone() {
        return phone;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PhoneSwitch && equalTo((PhoneSwitch) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PhoneSwitch other) {
        return type.equals(other.type) && phone.equals(other.phone);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.phone);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> phone = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(PhoneSwitch other) {
            type(other.getType());
            phone(other.getPhone());
            return this;
        }

        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.</p>
         */
        @JsonSetter(value = "phone", nulls = Nulls.SKIP)
        public Builder phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        public PhoneSwitch build() {
            return new PhoneSwitch(type, phone, additionalProperties);
        }
    }
}
