/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SlaApplied.Builder.class)
public final class SlaApplied {
    private final Optional<String> type;

    private final Optional<String> slaName;

    private final Optional<SlaStatus> slaStatus;

    private final Map<String, Object> additionalProperties;

    private SlaApplied(
            Optional<String> type,
            Optional<String> slaName,
            Optional<SlaStatus> slaStatus,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.slaName = slaName;
        this.slaStatus = slaStatus;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return object type
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The name of the SLA as given by the teammate when it was created.
     */
    @JsonProperty("sla_name")
    public Optional<String> getSlaName() {
        return slaName;
    }

    /**
     * @return SLA statuses:
     * - <code>hit</code>: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
     * - <code>missed</code>: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
     * - <code>active</code>: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.
     */
    @JsonProperty("sla_status")
    public Optional<SlaStatus> getSlaStatus() {
        return slaStatus;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SlaApplied && equalTo((SlaApplied) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SlaApplied other) {
        return type.equals(other.type) && slaName.equals(other.slaName) && slaStatus.equals(other.slaStatus);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.slaName, this.slaStatus);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> slaName = Optional.empty();

        private Optional<SlaStatus> slaStatus = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SlaApplied other) {
            type(other.getType());
            slaName(other.getSlaName());
            slaStatus(other.getSlaStatus());
            return this;
        }

        /**
         * <p>object type</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The name of the SLA as given by the teammate when it was created.</p>
         */
        @JsonSetter(value = "sla_name", nulls = Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        /**
         * <p>SLA statuses:
         * - <code>hit</code>: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
         * - <code>missed</code>: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
         * - <code>active</code>: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.</p>
         */
        @JsonSetter(value = "sla_status", nulls = Nulls.SKIP)
        public Builder slaStatus(Optional<SlaStatus> slaStatus) {
            this.slaStatus = slaStatus;
            return this;
        }

        public Builder slaStatus(SlaStatus slaStatus) {
            this.slaStatus = Optional.ofNullable(slaStatus);
            return this;
        }

        public SlaApplied build() {
            return new SlaApplied(type, slaName, slaStatus, additionalProperties);
        }
    }

    public static final class SlaStatus {
        public static final SlaStatus HIT = new SlaStatus(Value.HIT, "hit");

        public static final SlaStatus CANCELLED = new SlaStatus(Value.CANCELLED, "cancelled");

        public static final SlaStatus ACTIVE = new SlaStatus(Value.ACTIVE, "active");

        public static final SlaStatus MISSED = new SlaStatus(Value.MISSED, "missed");

        private final Value value;

        private final String string;

        SlaStatus(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof SlaStatus && this.string.equals(((SlaStatus) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case HIT:
                    return visitor.visitHit();
                case CANCELLED:
                    return visitor.visitCancelled();
                case ACTIVE:
                    return visitor.visitActive();
                case MISSED:
                    return visitor.visitMissed();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SlaStatus valueOf(String value) {
            switch (value) {
                case "hit":
                    return HIT;
                case "cancelled":
                    return CANCELLED;
                case "active":
                    return ACTIVE;
                case "missed":
                    return MISSED;
                default:
                    return new SlaStatus(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            HIT,

            MISSED,

            CANCELLED,

            ACTIVE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitHit();

            T visitMissed();

            T visitCancelled();

            T visitActive();

            T visitUnknown(String unknownType);
        }
    }
}
