/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketPartAuthor.Builder.class)
public final class TicketPartAuthor {
    private final Optional<Type> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<String> email;

    private final Map<String, Object> additionalProperties;

    private TicketPartAuthor(
            Optional<Type> type,
            Optional<String> id,
            Optional<String> name,
            Optional<String> email,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the author
     */
    @JsonProperty("type")
    public Optional<Type> getType() {
        return type;
    }

    /**
     * @return The id of the author
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The name of the author
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The email of the author
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketPartAuthor && equalTo((TicketPartAuthor) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketPartAuthor other) {
        return type.equals(other.type) && id.equals(other.id) && name.equals(other.name) && email.equals(other.email);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Type> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> email = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketPartAuthor other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            return this;
        }

        /**
         * <p>The type of the author</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(Type type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id of the author</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The name of the author</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The email of the author</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        public TicketPartAuthor build() {
            return new TicketPartAuthor(type, id, name, email, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type BOT = new Type(Value.BOT, "bot");

        public static final Type ADMIN = new Type(Value.ADMIN, "admin");

        public static final Type USER = new Type(Value.USER, "user");

        public static final Type TEAM = new Type(Value.TEAM, "team");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BOT:
                    return visitor.visitBot();
                case ADMIN:
                    return visitor.visitAdmin();
                case USER:
                    return visitor.visitUser();
                case TEAM:
                    return visitor.visitTeam();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "bot":
                    return BOT;
                case "admin":
                    return ADMIN;
                case "user":
                    return USER;
                case "team":
                    return TEAM;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ADMIN,

            BOT,

            TEAM,

            USER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitAdmin();

            T visitBot();

            T visitTeam();

            T visitUser();

            T visitUnknown(String unknownType);
        }
    }
}
