/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Translation.Builder.class)
public final class Translation {
    private final Optional<String> name;

    private final Optional<String> description;

    private final Optional<String> locale;

    private final Map<String, Object> additionalProperties;

    private Translation(
            Optional<String> name,
            Optional<String> description,
            Optional<String> locale,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The localised name of the subscription type.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The localised description of the subscription type.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The two character identifier for the language of the translation object.
     */
    @JsonProperty("locale")
    public Optional<String> getLocale() {
        return locale;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Translation && equalTo((Translation) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Translation other) {
        return name.equals(other.name) && description.equals(other.description) && locale.equals(other.locale);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.description, this.locale);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> locale = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Translation other) {
            name(other.getName());
            description(other.getDescription());
            locale(other.getLocale());
            return this;
        }

        /**
         * <p>The localised name of the subscription type.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The localised description of the subscription type.</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The two character identifier for the language of the translation object.</p>
         */
        @JsonSetter(value = "locale", nulls = Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public Translation build() {
            return new Translation(name, description, locale, additionalProperties);
        }
    }
}
