/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api;

import com.intercom.api.Intercom;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.Environment;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class IntercomBuilder {
    private Optional<Integer> timeout = Optional.empty();
    private Optional<Integer> maxRetries = Optional.empty();
    private final Map<String, String> customHeaders = new HashMap<String, String>();
    private String token = System.getenv("INTERCOM_API_KEY");
    private Environment environment = Environment.US_PRODUCTION;
    private OkHttpClient httpClient;

    public IntercomBuilder token(String token) {
        this.token = token;
        return this;
    }

    public IntercomBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public IntercomBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public IntercomBuilder timeout(int timeout) {
        this.timeout = Optional.of(timeout);
        return this;
    }

    public IntercomBuilder maxRetries(int maxRetries) {
        this.maxRetries = Optional.of(maxRetries);
        return this;
    }

    public IntercomBuilder httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public IntercomBuilder addHeader(String name, String value) {
        this.customHeaders.put(name, value);
        return this;
    }

    protected ClientOptions buildClientOptions() {
        ClientOptions.Builder builder = ClientOptions.builder();
        this.setEnvironment(builder);
        this.setAuthentication(builder);
        this.setHttpClient(builder);
        this.setTimeouts(builder);
        this.setRetries(builder);
        for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        this.setAdditional(builder);
        return builder.build();
    }

    protected void setEnvironment(ClientOptions.Builder builder) {
        builder.environment(this.environment);
    }

    protected void setAuthentication(ClientOptions.Builder builder) {
        if (this.token != null) {
            builder.addHeader("Authorization", "Bearer " + this.token);
        }
    }

    protected void setTimeouts(ClientOptions.Builder builder) {
        if (this.timeout.isPresent()) {
            builder.timeout(this.timeout.get());
        }
    }

    protected void setRetries(ClientOptions.Builder builder) {
        if (this.maxRetries.isPresent()) {
            builder.maxRetries(this.maxRetries.get());
        }
    }

    protected void setHttpClient(ClientOptions.Builder builder) {
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
    }

    protected void setAdditional(ClientOptions.Builder builder) {
    }

    protected void validateConfiguration() {
    }

    public Intercom build() {
        if (this.token == null) {
            throw new RuntimeException("Please provide token or set the INTERCOM_API_KEY environment variable.");
        }
        this.validateConfiguration();
        return new Intercom(this.buildClientOptions());
    }
}

