/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.core.pagination;

import java.util.List;
import java.util.Optional;

public abstract class BasePage<T> {
    private final boolean hasNext;
    private final List<T> items;
    private final Object response;

    public BasePage(boolean hasNext, List<T> items, Object response) {
        this.hasNext = hasNext;
        this.items = items;
        this.response = response;
    }

    public boolean hasNext() {
        return !this.items.isEmpty() && this.hasNext;
    }

    public List<T> getItems() {
        return this.items;
    }

    public <R> Optional<R> getResponse() {
        Object typedResponse = this.response;
        return Optional.ofNullable(typedResponse);
    }
}

